/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.generationDoc.gestcomm.PointageXmlSheet;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.ui.DefaultGridBagConstraints;

public class GenerationPointagePanel
extends JPanel
implements ActionListener {
    private final JButton gen = new JButton("G\u00e9n\u00e9rer");
    private final JButton close = new JButton("Fermer");
    private final SQLRequestComboBox combo = new SQLRequestComboBox(false);
    private final int currentYear = Calendar.getInstance().get(1);
    private final SpinnerModel model = new SpinnerNumberModel(this.currentYear, this.currentYear - 5, this.currentYear + 5, 1);
    private final JSpinner spinYear = new JSpinner(this.model);
    final JTextArea infos = new JTextArea();

    public GenerationPointagePanel() {
        super(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        SQLElement moisElt = Configuration.getInstance().getDirectory().getElement("MOIS");
        this.add((Component)new JLabel("Mois"), c);
        ++c.gridx;
        ComboSQLRequest comboReq = new ComboSQLRequest(moisElt.getComboRequest());
        this.combo.uiInit(comboReq);
        this.add((Component)this.combo, c);
        this.add((Component)new JLabel("Ann\u00e9e"), c);
        ++c.gridx;
        this.add((Component)this.spinYear, c);
        JPanel panelButton = new JPanel();
        panelButton.add(this.gen);
        panelButton.add(this.close);
        this.gen.setEnabled(false);
        c.fill = 0;
        c.weightx = 0.0;
        c.anchor = 13;
        c.weighty = 0.0;
        ++c.gridy;
        this.add((Component)panelButton, c);
        this.combo.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                GenerationPointagePanel.this.gen.setEnabled(GenerationPointagePanel.this.combo.getSelectedRow() != null);
            }
        });
        this.gen.addActionListener(this);
        this.close.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.gen) {
            int mois = this.combo.getValue() - 2;
            int year = Integer.valueOf(this.spinYear.getValue().toString());
            PointageXmlSheet sheet = new PointageXmlSheet(mois, year);
            sheet.createDocumentAsynchronous();
            sheet.showPrintAndExportAsynchronous(true, false, true);
        } else if (e.getSource() == this.close) {
            ((JFrame)SwingUtilities.getRoot(this)).dispose();
        }
    }
}

