/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Color;
import java.awt.Component;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.openconcerto.erp.core.finance.accounting.model.ConsultCompteModel;
import org.openconcerto.erp.element.objet.Ecriture;
import org.openconcerto.ui.table.TableCellRendererUtils;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.TableSorter;

public class EcritureGrandLivreRenderer
extends DefaultTableCellRenderer {
    private TableSorter model;
    private static final DateFormat dateFormat = DateFormat.getDateInstance(2, Locale.FRENCH);
    private static final Color couleurEcritureValide = new Color(253, 243, 204);
    private static final Color couleurEcritureToDay = new Color(225, 254, 207);

    public EcritureGrandLivreRenderer(TableSorter model) {
        this.model = model;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Ecriture ecrTmp;
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        TableCellRendererUtils.setBackgroundColor(this, table, isSelected);
        if (!isSelected && !(ecrTmp = ((ConsultCompteModel)this.model.getTableModel()).getEcritures().get(this.model.viewIndex(row))).getValide()) {
            Date dateEcr = ecrTmp.getDate();
            Date dateToDay = new Date();
            if (dateEcr.getDate() == dateToDay.getDate() && dateEcr.getMonth() == dateToDay.getMonth() && dateEcr.getYear() == dateToDay.getYear()) {
                this.setBackground(couleurEcritureToDay);
            } else {
                this.setBackground(couleurEcritureValide);
            }
        }
        if (value instanceof Date) {
            this.setText(dateFormat.format((Date)value));
        }
        if (value.getClass() == Long.class) {
            this.setText(GestionDevise.currencyToString((Long)value));
        }
        return this;
    }
}

