/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.customerrelationship.customer.action;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.customerrelationship.customer.action.ListeDesClientsAction;
import org.openconcerto.map.model.Ville;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.view.list.BaseSQLTableModelColumn;
import org.openconcerto.sql.view.list.SQLTableModelSource;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;

public class ListeDesClientsTCPAction
extends ListeDesClientsAction {
    public ListeDesClientsTCPAction() {
        this.putValue("Name", "Liste des clients export CTech");
    }

    @Override
    protected SQLTableModelSource getTableSource() {
        final SQLTable tableClient = ((ComptaPropsConfiguration)Configuration.getInstance()).getRootSociete().getTable("CLIENT");
        SQLTableModelSourceOnline table = Configuration.getInstance().getDirectory().getElement(tableClient).getTableSource(true);
        BaseSQLTableModelColumn dateRG = new BaseSQLTableModelColumn("Contact", String.class){

            @Override
            protected Object show_(SQLRowAccessor r) {
                Collection<? extends SQLRowAccessor> rowsCmd = (r = r.asRow()).getReferentRows(tableClient.getTable("CONTACT"));
                if (rowsCmd != null && rowsCmd.size() > 0) {
                    SQLRowAccessor rowAff = (SQLRowAccessor)rowsCmd.toArray()[0];
                    return rowAff.getString("NOM");
                }
                return "";
            }

            @Override
            public Set<FieldPath> getPaths() {
                return Collections.emptySet();
            }
        };
        table.getColumns().add(dateRG);
        BaseSQLTableModelColumn adr = new BaseSQLTableModelColumn("Adresse Facturation", String.class){

            @Override
            protected Object show_(SQLRowAccessor r) {
                Collection<? extends SQLRowAccessor> rowsCmd = (r = r.asRow()).getReferentRows(tableClient.getTable("ADRESSE"));
                if (rowsCmd != null && rowsCmd.size() > 0) {
                    SQLRowAccessor rowAff = (SQLRowAccessor)rowsCmd.toArray()[0];
                    Ville v = Ville.getVilleContaining(rowAff.getString("VILLE"));
                    if (v != null) {
                        return String.valueOf(rowAff.getString("RUE")) + " " + v.getCodepostal() + " " + v.getName();
                    }
                    return String.valueOf(rowAff.getString("RUE")) + "  " + rowAff.getString("VILLE");
                }
                return "";
            }

            @Override
            public Set<FieldPath> getPaths() {
                return Collections.EMPTY_SET;
            }
        };
        table.getColumns().add(adr);
        return table;
    }
}

