/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.erp.model.PrixHT;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.sql.view.list.SQLTableElement;

public class TotalTextField
extends JTextField
implements TableModelListener {
    private RowValuesTableModel model;
    private int columnIndex;

    public TotalTextField(RowValuesTableModel model, SQLTableElement e) {
        this.model = model;
        this.columnIndex = model.getColumnIndexForElement(e);
        if (this.columnIndex < 0) {
            throw new IllegalArgumentException("Impossible de trouver la colonne de " + e);
        }
        this.updateTotal();
        model.addTableModelListener(this);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getColumn() == -1 || e.getColumn() == this.columnIndex) {
            System.out.println(e);
            this.updateTotal();
        }
    }

    private void updateTotal() {
        double total = 0.0;
        int i = 0;
        while (i < this.model.getRowCount()) {
            Number n = (Number)this.model.getValueAt(i, this.columnIndex);
            total += n.doubleValue();
            ++i;
        }
        this.setText(new PrixHT(total).toString());
    }
}

