/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.ITransformer;

public class IListFilterDatePanel
extends JPanel {
    private JDate dateDu;
    private JDate dateAu;
    private Map<IListe, SQLField> mapList;
    private Map<String, Tuple2<Date, Date>> map;
    private ITransformer<SQLSelect, SQLSelect> t;
    private final PropertyChangeListener listener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            IListFilterDatePanel.this.fireDateChanged();
        }
    };

    public IListFilterDatePanel(IListe l, SQLField fieldDate) {
        this(l, fieldDate, null);
    }

    public static Map<String, Tuple2<Date, Date>> getDefaultMap() {
        Calendar c = Calendar.getInstance();
        LinkedHashMap<String, Tuple2<Date, Date>> m = new LinkedHashMap<String, Tuple2<Date, Date>>();
        c.set(5, 1);
        c.set(2, 0);
        Date d1 = c.getTime();
        c.set(5, 31);
        c.set(2, 11);
        Date d2 = c.getTime();
        m.put("Ann\u00e9e courante", Tuple2.create(d1, d2));
        c.set(5, 1);
        c.set(2, 0);
        c.add(1, -1);
        Date d3 = c.getTime();
        c.set(5, 31);
        c.set(2, 11);
        Date d4 = c.getTime();
        m.put("Ann\u00e9e pr\u00e9c\u00e9dente", Tuple2.create(d3, d4));
        c = Calendar.getInstance();
        c.set(5, 1);
        Date d5 = c.getTime();
        c.set(5, c.getActualMaximum(5));
        Date d6 = c.getTime();
        m.put("Mois courant", Tuple2.create(d5, d6));
        c = Calendar.getInstance();
        c.set(5, 1);
        c.add(2, -1);
        Date d7 = c.getTime();
        c.set(5, c.getActualMaximum(5));
        Date d8 = c.getTime();
        m.put("Mois pr\u00e9c\u00e9dent", Tuple2.create(d7, d8));
        c = Calendar.getInstance();
        c.set(7, 2);
        Date d9 = c.getTime();
        c.set(7, 1);
        Date d10 = c.getTime();
        m.put("Semaine courante", Tuple2.create(d9, d10));
        c = Calendar.getInstance();
        c.add(5, -7);
        c.set(7, 2);
        Date d11 = c.getTime();
        c.set(7, 1);
        Date d12 = c.getTime();
        m.put("Semaine pr\u00e9c\u00e9dente", Tuple2.create(d11, d12));
        return m;
    }

    public void setITransformer(ITransformer<SQLSelect, SQLSelect> t) {
        this.t = t;
    }

    public IListFilterDatePanel(IListe l, SQLField fieldDate, Map<String, Tuple2<Date, Date>> m) {
        super(new GridBagLayout());
        HashMap<IListe, SQLField> map = new HashMap<IListe, SQLField>();
        map.put(l, fieldDate);
        this.init(map, m);
    }

    public IListFilterDatePanel(Map<IListe, SQLField> l, Map<String, Tuple2<Date, Date>> m) {
        super(new GridBagLayout());
        this.init(l, m);
    }

    public void init(Map<IListe, SQLField> mapList, Map<String, Tuple2<Date, Date>> m) {
        this.setBorder(BorderFactory.createTitledBorder("P\u00e9riode"));
        this.mapList = mapList;
        this.dateDu = new JDate();
        this.dateAu = new JDate();
        this.map = m;
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridx = -1;
        c.weightx = 0.0;
        if (this.map != null && this.map.keySet().size() > 0) {
            DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
            model.addElement("Tous");
            for (String s : this.map.keySet()) {
                model.addElement(s);
            }
            final JComboBox combo = new JComboBox(model);
            c.weightx = 0.0;
            this.add(combo, c);
            combo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String s = (String)combo.getSelectedItem();
                    IListFilterDatePanel.this.setPeriode((Tuple2)IListFilterDatePanel.this.map.get(s));
                }
            });
        }
        this.add((Component)new JLabel("Du"), c);
        this.add((Component)this.dateDu, c);
        this.add((Component)new JLabel("Au"), c);
        this.add((Component)this.dateAu, c);
        this.dateAu.addValueListener(this.listener);
        this.dateDu.addValueListener(this.listener);
    }

    public void setDateDu(Date d) {
        this.dateDu.setValue(d);
    }

    public void setDateAu(Date d) {
        this.dateAu.setValue(d);
    }

    public void setFilterOnCurrentYear() {
        Calendar c = Calendar.getInstance();
        c.set(2, 0);
        c.set(5, 1);
        Date d = c.getTime();
        c.set(2, 11);
        c.set(5, c.getMaximum(5));
        Date d2 = c.getTime();
        this.setPeriode(d, d2);
    }

    public void setPeriode(Tuple2<Date, Date> t) {
        if (t == null) {
            this.setPeriode(null, null);
        } else {
            this.setPeriode(t.get0(), t.get1());
        }
    }

    public void setPeriode(Date du, Date au) {
        this.dateAu.rmValueListener(this.listener);
        this.dateDu.rmValueListener(this.listener);
        this.setDateAu(au);
        this.setDateDu(du);
        this.fireDateChanged();
        this.dateAu.addValueListener(this.listener);
        this.dateDu.addValueListener(this.listener);
    }

    public void fireDateChanged() {
        if (this.dateAu.getValue() == null && this.dateDu.getValue() == null) {
            System.err.println("Null ");
            if (this.t != null) {
                for (IListe list : this.mapList.keySet()) {
                    list.getRequest().setSelectTransf(this.t);
                }
            } else {
                for (IListe list : this.mapList.keySet()) {
                    list.getRequest().setSelectTransf(null);
                }
            }
            return;
        }
        if (this.dateAu.getValue() == null) {
            System.err.println("Du " + this.dateDu.getValue());
            final Calendar c = Calendar.getInstance();
            c.setTime(this.dateDu.getValue());
            c.set(11, 0);
            c.set(12, 0);
            c.set(14, 1);
            for (IListe list : this.mapList.keySet()) {
                final SQLField filterField = this.mapList.get(list);
                list.getRequest().setSelectTransf(new ITransformer<SQLSelect, SQLSelect>(){

                    @Override
                    public SQLSelect transformChecked(SQLSelect input) {
                        if (IListFilterDatePanel.this.t != null) {
                            input = (SQLSelect)IListFilterDatePanel.this.t.transformChecked(input);
                        }
                        input.andWhere(new Where((FieldRef)input.getAlias(filterField), ">=", (Object)c.getTime()));
                        return input;
                    }
                });
            }
            return;
        }
        if (this.dateDu.getValue() == null) {
            System.err.println("Au " + this.dateAu.getValue());
            final Calendar c = Calendar.getInstance();
            c.setTime(this.dateAu.getValue());
            c.set(11, 23);
            c.set(12, 59);
            c.set(14, 59);
            for (IListe list : this.mapList.keySet()) {
                final SQLField filterField = this.mapList.get(list);
                list.getRequest().setSelectTransf(new ITransformer<SQLSelect, SQLSelect>(){

                    @Override
                    public SQLSelect transformChecked(SQLSelect input) {
                        if (IListFilterDatePanel.this.t != null) {
                            input = (SQLSelect)IListFilterDatePanel.this.t.transformChecked(input);
                        }
                        input.andWhere(new Where((FieldRef)input.getAlias(filterField), "<=", (Object)c.getTime()));
                        return input;
                    }
                });
            }
            return;
        }
        System.err.println("Between ");
        final Calendar c = Calendar.getInstance();
        c.setTime(this.dateAu.getValue());
        c.set(11, 23);
        c.set(12, 59);
        c.set(14, 59);
        final Calendar c2 = Calendar.getInstance();
        c2.setTime(this.dateDu.getValue());
        c2.set(11, 0);
        c2.set(12, 0);
        c2.set(14, 1);
        for (IListe list : this.mapList.keySet()) {
            final SQLField filterField = this.mapList.get(list);
            list.getRequest().setSelectTransf(new ITransformer<SQLSelect, SQLSelect>(){

                @Override
                public SQLSelect transformChecked(SQLSelect input) {
                    if (IListFilterDatePanel.this.t != null) {
                        input = (SQLSelect)IListFilterDatePanel.this.t.transformChecked(input);
                    }
                    input.andWhere(new Where((FieldRef)input.getAlias(filterField), c2.getTime(), (Object)c.getTime()));
                    return input;
                }
            });
        }
    }
}

