/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.erp.model.PrixHT;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.sql.view.list.SQLTableElement;

public class DifferenceTextField
extends JTextField
implements TableModelListener {
    private RowValuesTableModel model;
    private int columnIndex1;
    private int columnIndex2;

    public DifferenceTextField(RowValuesTableModel model, SQLTableElement e1, SQLTableElement e2) {
        this.model = model;
        this.columnIndex1 = model.getColumnIndexForElement(e1);
        this.columnIndex2 = model.getColumnIndexForElement(e2);
        if (this.columnIndex1 < 0 || this.columnIndex2 < 0) {
            throw new IllegalArgumentException("Impossible de trouver la colonne de " + e1 + " / " + e2);
        }
        this.updateTotal();
        model.addTableModelListener(this);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getColumn() == -1 || e.getColumn() == this.columnIndex1 || e.getColumn() == this.columnIndex2) {
            System.out.println(e);
            this.updateTotal();
        }
    }

    private void updateTotal() {
        double total1 = 0.0;
        int i = 0;
        while (i < this.model.getRowCount()) {
            Number n = (Number)this.model.getValueAt(i, this.columnIndex1);
            total1 += n.doubleValue();
            ++i;
        }
        double total2 = 0.0;
        int i2 = 0;
        while (i2 < this.model.getRowCount()) {
            Number n = (Number)this.model.getValueAt(i2, this.columnIndex2);
            total2 += n.doubleValue();
            ++i2;
        }
        this.setText(new PrixHT(total1 - total2).toString());
    }
}

