/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.action;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.JFrame;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.generationDoc.DocumentLocalStorageManager;
import org.openconcerto.erp.preferences.BackupNXProps;
import org.openconcerto.erp.preferences.TemplateNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.utils.BackupPanel;

public class SauvegardeBaseAction
extends CreateFrameAbstractAction {
    public SauvegardeBaseAction() {
        this.putValue("Name", "Sauvegarde de la base");
    }

    @Override
    public JFrame createFrame() {
        String serverIp;
        JFrame frame = new JFrame();
        ArrayList<File> dirs = new ArrayList<File>();
        TemplateNXProps nxprops = (TemplateNXProps)TemplateNXProps.getInstance();
        String defaultLocation = nxprops.getDefaultStringValue();
        HashSet<String> locations = new HashSet<String>();
        File defaultLocationFile = new File(defaultLocation);
        if (defaultLocationFile.exists()) {
            dirs.add(defaultLocationFile);
        }
        if ((serverIp = ((ComptaPropsConfiguration)Configuration.getInstance()).getServerIp()) != null && serverIp.startsWith("file:")) {
            locations.add(serverIp.substring(5));
        }
        DocumentLocalStorageManager storage = DocumentLocalStorageManager.getInstance();
        locations.add(defaultLocation);
        for (File f : storage.getAllDocumentDirectories()) {
            locations.add(f.getAbsolutePath());
        }
        for (File f : storage.getAllPDFDirectories()) {
            locations.add(f.getAbsolutePath());
        }
        for (String string : locations) {
            if (!string.startsWith(defaultLocation)) {
                File f = new File(string);
                if (f.exists()) {
                    System.out.println("Directory to backup:" + string);
                    dirs.add(f);
                    continue;
                }
                System.out.println(String.valueOf(string) + " not found");
                continue;
            }
            System.out.println(String.valueOf(string) + " already in backup path");
        }
        frame.setContentPane(new BackupPanel(Arrays.asList("Common", ((ComptaPropsConfiguration)Configuration.getInstance()).getSocieteBaseName()), dirs, false, BackupNXProps.getInstance()));
        frame.setTitle("Sauvegarde des donn\u00e9es");
        frame.setDefaultCloseOperation(2);
        frame.setLocationRelativeTo(null);
        frame.pack();
        frame.setMinimumSize(frame.getSize());
        frame.setIconImages(Gestion.getFrameIcon());
        frame.setAlwaysOnTop(true);
        frame.setVisible(true);
        return frame;
    }
}

