/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.action;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.erp.config.MainFrame;
import org.openconcerto.erp.core.common.ui.PanelFrame;
import org.openconcerto.erp.core.common.ui.StatusPanel;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.humanresources.payroll.element.CaisseCotisationSQLElement;
import org.openconcerto.erp.element.objet.ClasseCompte;
import org.openconcerto.erp.modules.ModuleManager;
import org.openconcerto.erp.panel.ComptaTipsFrame;
import org.openconcerto.erp.utils.NXDatabaseAccessor;
import org.openconcerto.map.model.Ville;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBackgroundTableCache;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.UndefinedRowValuesCache;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.sql.preferences.UserProps;
import org.openconcerto.sql.sqlobject.IComboSelectionItem;
import org.openconcerto.sql.ui.ConnexionPanel;
import org.openconcerto.task.config.ComptaBasePropsConfiguration;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.JImage;

public class NouvelleConnexionAction
extends CreateFrameAbstractAction {
    private ConnexionPanel connexionPanel;

    public NouvelleConnexionAction() {
        this.putValue("Name", "Changer d'utilisateur");
    }

    @Override
    public JFrame createFrame() {
        assert (SwingUtilities.isEventDispatchThread());
        final ComptaPropsConfiguration comptaPropsConfiguration = (ComptaPropsConfiguration)Configuration.getInstance();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    int selectedSociete;
                    Boolean booleanValue = UserProps.getInstance().getBooleanValue("HideTips");
                    if (!booleanValue.booleanValue()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ComptaTipsFrame.getFrame(true).setVisible(true);
                            }
                        });
                    }
                    if (NouvelleConnexionAction.this.connexionPanel != null && !Gestion.isMinimalMode()) {
                        selectedSociete = NouvelleConnexionAction.this.connexionPanel.getSelectedSociete();
                    } else {
                        selectedSociete = UserProps.getInstance().getLastSocieteID();
                        if (selectedSociete < 0) {
                            SQLElement elem = comptaPropsConfiguration.getDirectory().getElement(comptaPropsConfiguration.getRoot().getTable("SOCIETE_COMMON"));
                            List<IComboSelectionItem> comboItems = elem.getComboRequest().getComboItems();
                            if (comboItems.size() > 0) {
                                selectedSociete = comboItems.get(0).getId();
                            } else {
                                throw new IllegalStateException("No " + elem + " found");
                            }
                        }
                    }
                    comptaPropsConfiguration.setUpSocieteDataBaseConnexion(selectedSociete);
                    try {
                        ModuleManager.getInstance().setup(comptaPropsConfiguration.getRootSociete(), comptaPropsConfiguration);
                    }
                    catch (Exception e) {
                        ExceptionHandler.die("Impossible de d\u00e9marrer les modules requis", e);
                    }
                    try {
                        SQLPreferences.getPrefTable(comptaPropsConfiguration.getRootSociete());
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle("Impossible d'acc\u00e9der aux pr\u00e9f\u00e9rences", e);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            StatusPanel.getInstance().fireStatusChanged();
                            MainFrame f = new MainFrame();
                            String version = comptaPropsConfiguration.getVersion();
                            String socTitle = comptaPropsConfiguration.getRowSociete() == null ? "" : ", [Soci\u00e9t\u00e9 " + comptaPropsConfiguration.getRowSociete().getString("NOM") + "]";
                            f.setTitle(String.valueOf(comptaPropsConfiguration.getAppName()) + " " + version + socTitle);
                            f.setDefaultCloseOperation(0);
                            try {
                                ModuleManager.getInstance().startRequiredModules();
                            }
                            catch (Exception exn) {
                                ExceptionHandler.die("Impossible de d\u00e9marrer les modules requis", exn);
                            }
                            try {
                                ModuleManager.getInstance().startPreviouslyRunningModules();
                            }
                            catch (Exception exn) {
                                ExceptionHandler.handle(f, "Impossible de d\u00e9marrer les modules", exn);
                            }
                            FrameUtil.show(f);
                        }
                    });
                    NouvelleConnexionAction.this.initCache();
                }
                catch (Throwable e) {
                    ExceptionHandler.handle("Erreur de connexion", e);
                }
            }

            private void fixEcriture() {
                SQLElement elt = Configuration.getInstance().getDirectory().getElement("ECRITURE");
                SQLSelect sel = new SQLSelect(Configuration.getInstance().getBase());
                sel.addSelect(elt.getTable().getKey());
                Where w = new Where((FieldRef)elt.getTable().getField("ID_MOUVEMENT"), "=", 1);
                sel.setWhere(w);
                System.err.println(sel.asString());
                List lerrors = (List)Configuration.getInstance().getBase().getDataSource().execute(sel.asString(), new SQLRowListRSH(elt.getTable()));
                for (SQLRow row : lerrors) {
                    System.err.println("FIX ERROR ID_MOUVEMENT ON ECRITURE ROW " + row.getID());
                    SQLRowValues rowVals = row.createEmptyUpdateRow();
                    rowVals.put("ARCHIVE", 1);
                    try {
                        rowVals.update();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                if (lerrors.size() > 0) {
                    System.err.println(String.valueOf(lerrors.size()) + " erreurs");
                    Thread.dumpStack();
                }
            }
        };
        JImage image = new JImage(ComptaBasePropsConfiguration.class.getResource("logo.png"));
        image.setBackground(Color.WHITE);
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 1;
        this.connexionPanel = ConnexionPanel.create(r, image, !Gestion.isMinimalMode());
        if (this.connexionPanel == null) {
            return null;
        }
        p.add((Component)this.connexionPanel, c);
        PanelFrame panelFrame = new PanelFrame(p, "Connexion");
        panelFrame.setLocationRelativeTo(null);
        panelFrame.pack();
        panelFrame.setDefaultCloseOperation(2);
        return panelFrame;
    }

    private void initCache() {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ClasseCompte.loadClasseCompte();
                CaisseCotisationSQLElement.getCaisseCotisation();
                Ville.init(new NXDatabaseAccessor());
                SQLBase baseSociete = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
                SQLBackgroundTableCache.getInstance().add(baseSociete.getTable("TAXE"), 600);
                SQLBackgroundTableCache.getInstance().add(baseSociete.getTable("PREFS_COMPTE"), 600);
                SQLBackgroundTableCache.getInstance().add(baseSociete.getTable("JOURNAL"), 600);
                SQLBackgroundTableCache.getInstance().add(baseSociete.getTable("COMMERCIAL"), 600);
                SQLBackgroundTableCache.getInstance().add(baseSociete.getTable("TYPE_REGLEMENT"), 1000);
                TaxeCache.getCache();
                UndefinedRowValuesCache UndefCache = UndefinedRowValuesCache.getInstance();
                UndefCache.getDefaultRowValues(baseSociete.getTable("ADRESSE"));
                UndefCache.getDefaultRowValues(baseSociete.getTable("DEVIS_ELEMENT"));
                UndefCache.getDefaultRowValues(baseSociete.getTable("CONTACT"));
                UndefCache.getDefaultRowValues(baseSociete.getTable("SAISIE_VENTE_FACTURE_ELEMENT"));
                UndefCache.getDefaultRowValues(baseSociete.getTable("SAISIE_KM_ELEMENT"));
                UndefCache.getDefaultRowValues(baseSociete.getTable("BON_DE_LIVRAISON_ELEMENT"));
                UndefCache.getDefaultRowValues(baseSociete.getTable("COMMANDE_CLIENT_ELEMENT"));
                UndefCache.getDefaultRowValues(baseSociete.getTable("AVOIR_CLIENT_ELEMENT"));
                UndefCache.getDefaultRowValues(baseSociete.getTable("BON_RECEPTION_ELEMENT"));
            }
        };
        t.setName("Cache preload");
        t.setDaemon(true);
        t.setPriority(1);
        t.start();
    }

    private String checkLicense(SwingWorker<String, Object> w) {
        try {
            return w.get();
        }
        catch (Exception e) {
            throw ExceptionHandler.die("Impossible de charger la licence.", e);
        }
    }
}

