/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util.convertor;

import java.sql.Clob;
import javax.sql.rowset.serial.SerialClob;
import org.jopendocument.util.convertor.NullIsNullConvertor;

public class StringClobConvertor
extends NullIsNullConvertor<String, Clob> {
    public static final StringClobConvertor INSTANCE = new StringClobConvertor(null);
    public static final StringClobConvertor INSTANCE_LENIENT = new StringClobConvertor(Integer.MAX_VALUE);
    private final Integer maxLength;

    public StringClobConvertor(int n) {
        this((Integer)n);
    }

    public StringClobConvertor(Integer n) {
        this.maxLength = n;
    }

    @Override
    protected Clob convertNonNull(String string) {
        try {
            return new SerialClob(string.toCharArray());
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    @Override
    protected String unconvertNonNull(Clob clob) {
        try {
            int n;
            long l = clob.length();
            if (this.maxLength != null) {
                n = (int)Math.min(l, this.maxLength.longValue());
            } else {
                if (l > Integer.MAX_VALUE) {
                    throw new IllegalStateException("Clob too long: " + l);
                }
                n = (int)l;
            }
            return clob.getSubString(1L, n);
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }
}

