/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util.convertor;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jopendocument.util.convertor.ValueConvertor;

public abstract class NumberConvertor<T extends Number, U extends Number>
implements ValueConvertor<T, U> {
    public static final NumberConvertor<Integer, Long> INT_TO_LONG = new NumberConvertor<Integer, Long>(){

        @Override
        public Long convert(Integer n) {
            return n.longValue();
        }

        @Override
        public Integer unconvert(Long l) {
            return l.intValue();
        }
    };
    public static final NumberConvertor<Short, Integer> SHORT_TO_INT = new NumberConvertor<Short, Integer>(){

        @Override
        public Integer convert(Short s) {
            return s.intValue();
        }

        @Override
        public Short unconvert(Integer n) {
            return n.shortValue();
        }
    };
    public static final BigDecimal MAX_FLOAT = BigDecimal.valueOf(3.4028234663852886E38);
    public static final BigDecimal MIN_FLOAT = MAX_FLOAT.negate();
    public static final BigDecimal MAX_DOUBLE = BigDecimal.valueOf(Double.MAX_VALUE);
    public static final BigDecimal MIN_DOUBLE = MAX_DOUBLE.negate();

    public static final <N1 extends Number, N2 extends Number> NumberConvertor<N1, N2> create(final Class<N1> clazz, final Class<N2> clazz2, final boolean bl) {
        return new NumberConvertor<N1, N2>(){

            @Override
            public N2 convert(N1 N1) {
                return bl ? 3.convertExact(N1, clazz2) : 3.convert(N1, clazz2);
            }

            @Override
            public N1 unconvert(N2 N2) {
                return bl ? 3.convertExact(N2, clazz) : 3.convert(N2, clazz);
            }
        };
    }

    public static <N extends Number> N convert(Number number, Class<N> clazz) {
        Number number2;
        if (number == null || number.getClass() == clazz || clazz == Number.class) {
            number2 = number;
        } else if (clazz == Short.class) {
            number2 = number.shortValue();
        } else if (clazz == Integer.class) {
            number2 = number.intValue();
        } else if (clazz == Long.class) {
            number2 = number.longValue();
        } else if (clazz == Byte.class) {
            number2 = number.byteValue();
        } else if (clazz == BigInteger.class) {
            number2 = number instanceof BigDecimal ? ((BigDecimal)number).toBigInteger() : (number instanceof Byte || number instanceof Short || number instanceof Integer || number instanceof AtomicInteger || number instanceof Long || number instanceof AtomicLong ? BigInteger.valueOf(number.longValue()) : (number instanceof Float || number instanceof Double ? BigDecimal.valueOf(number.doubleValue()).toBigInteger() : new BigInteger(number.toString())));
        } else if (clazz == AtomicInteger.class) {
            number2 = new AtomicInteger(number.intValue());
        } else if (clazz == AtomicLong.class) {
            number2 = new AtomicLong(number.longValue());
        } else if (clazz == BigDecimal.class) {
            number2 = NumberConvertor.toBigDecimal(number);
        } else if (clazz == Double.class) {
            number2 = number.doubleValue();
        } else if (clazz == Float.class) {
            number2 = Float.valueOf(number.floatValue());
        } else {
            throw new IllegalArgumentException("unknown class: " + clazz);
        }
        return (N)((Number)clazz.cast(number2));
    }

    public static BigDecimal toBigDecimal(Number number) {
        BigDecimal bigDecimal = number == null || number instanceof BigDecimal ? (BigDecimal)number : (number instanceof Byte || number instanceof Short || number instanceof Integer || number instanceof AtomicInteger || number instanceof Long || number instanceof AtomicLong ? BigDecimal.valueOf(number.longValue()) : (number instanceof Float || number instanceof Double ? BigDecimal.valueOf(number.doubleValue()) : (number instanceof BigInteger ? new BigDecimal((BigInteger)number) : new BigDecimal(number.toString()))));
        return bigDecimal;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <N extends Number> N convertExact(Number number, Class<N> clazz) throws OverflowException, RoundingException {
        void var2_17;
        if (number == null || number.getClass() == clazz || clazz == Number.class) {
            Number number2 = number;
            return (N)((Number)clazz.cast(var2_17));
        }
        if (number instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)number;
            if (clazz == Byte.class || clazz == Short.class || clazz == Integer.class || clazz == AtomicInteger.class || clazz == Long.class || clazz == AtomicLong.class || clazz == BigInteger.class) {
                BigInteger bigInteger;
                try {
                    bigInteger = bigDecimal.toBigIntegerExact();
                }
                catch (ArithmeticException arithmeticException) {
                    throw new RoundingException(number, clazz);
                }
                if (clazz == BigInteger.class) {
                    BigInteger bigInteger2 = bigInteger;
                    return (N)((Number)clazz.cast(var2_17));
                } else {
                    try {
                        N n = NumberConvertor.convertExact(bigInteger, clazz);
                        return (N)((Number)clazz.cast(var2_17));
                    }
                    catch (RoundingException roundingException) {
                        throw new IllegalStateException(roundingException);
                    }
                    catch (OverflowException overflowException) {
                        throw new OverflowException(number, clazz).initCause(overflowException);
                    }
                }
            }
            if (clazz == Float.class) {
                if (bigDecimal.compareTo(MAX_FLOAT) > 0 || bigDecimal.compareTo(MIN_FLOAT) < 0) {
                    throw new OverflowException(number, clazz);
                }
                Float f = Float.valueOf(number.floatValue());
                return (N)((Number)clazz.cast(var2_17));
            } else {
                if (clazz != Double.class) throw new IllegalStateException("Unknown class " + number.getClass());
                if (bigDecimal.compareTo(MAX_DOUBLE) > 0 || bigDecimal.compareTo(MIN_DOUBLE) < 0) {
                    throw new OverflowException(number, clazz);
                }
                Double d = number.doubleValue();
            }
            return (N)((Number)clazz.cast(var2_17));
        }
        if (clazz == Byte.class) {
            byte by = number.byteValue();
            if (number instanceof Short || number instanceof Integer || number instanceof AtomicInteger || number instanceof Long || number instanceof AtomicLong) {
                if ((long)by != number.longValue()) {
                    throw new OverflowException(number, clazz);
                }
            } else if (number instanceof BigInteger) {
                if (((BigInteger)number).bitLength() >= 8) {
                    throw new OverflowException(number, clazz);
                }
            } else {
                if (!(number instanceof Float) && !(number instanceof Double)) throw new IllegalStateException("Unknown class " + number.getClass());
                if (!(number.doubleValue() > 127.0) && !(number.doubleValue() < -128.0)) throw new RoundingException(number, clazz);
                throw new OverflowException(number, clazz);
            }
            Byte by2 = by;
            return (N)((Number)clazz.cast(var2_17));
        } else if (clazz == Short.class) {
            short s = number.shortValue();
            if (number instanceof Integer || number instanceof AtomicInteger || number instanceof Long || number instanceof AtomicLong) {
                if ((long)s != number.longValue()) {
                    throw new OverflowException(number, clazz);
                }
            } else if (!(number instanceof Byte)) {
                if (number instanceof BigInteger) {
                    if (((BigInteger)number).bitLength() >= 16) {
                        throw new OverflowException(number, clazz);
                    }
                } else {
                    if (!(number instanceof Float) && !(number instanceof Double)) throw new IllegalStateException("Unknown class " + number.getClass());
                    if (!(number.doubleValue() > 32767.0) && !(number.doubleValue() < -32768.0)) throw new RoundingException(number, clazz);
                    throw new OverflowException(number, clazz);
                }
            }
            Short s2 = s;
            return (N)((Number)clazz.cast(var2_17));
        } else if (clazz == Integer.class || clazz == AtomicInteger.class) {
            int n = number.intValue();
            if (number instanceof Long || number instanceof AtomicLong) {
                if ((long)n != number.longValue()) {
                    throw new OverflowException(number, clazz);
                }
            } else if (!(number instanceof Byte || number instanceof Short || number instanceof Integer || number instanceof AtomicInteger)) {
                if (number instanceof BigInteger) {
                    if (((BigInteger)number).bitLength() >= 32) {
                        throw new OverflowException(number, clazz);
                    }
                } else {
                    if (!(number instanceof Float) && !(number instanceof Double)) throw new IllegalStateException("Unknown class " + number.getClass());
                    if (!(number.doubleValue() > 2.147483647E9) && !(number.doubleValue() < -2.147483648E9)) throw new RoundingException(number, clazz);
                    throw new OverflowException(number, clazz);
                }
            }
            Number number3 = clazz == Integer.class ? Integer.valueOf(n) : new AtomicInteger(n);
            return (N)((Number)clazz.cast(var2_17));
        } else if (clazz == Long.class || clazz == AtomicLong.class) {
            long l = number.longValue();
            if (!(number instanceof Byte || number instanceof Short || number instanceof Integer || number instanceof AtomicInteger || number instanceof Long || number instanceof AtomicLong)) {
                if (number instanceof BigInteger) {
                    if (((BigInteger)number).bitLength() >= 64) {
                        throw new OverflowException(number, clazz);
                    }
                } else {
                    if (!(number instanceof Float) && !(number instanceof Double)) throw new IllegalStateException("Unknown class " + number.getClass());
                    if (!(number.doubleValue() >= 9.223372036854776E18) && !(number.doubleValue() <= -9.223372036854776E18)) throw new RoundingException(number, clazz);
                    throw new OverflowException(number, clazz);
                }
            }
            Number number4 = clazz == Long.class ? Long.valueOf(l) : new AtomicLong(l);
            return (N)((Number)clazz.cast(var2_17));
        } else if (clazz == BigInteger.class) {
            if (!(number instanceof Byte || number instanceof Short || number instanceof Integer || number instanceof AtomicInteger || number instanceof Long || number instanceof AtomicLong)) {
                if (!(number instanceof Float) && !(number instanceof Double)) throw new IllegalStateException("Unknown class " + number.getClass());
                throw new RoundingException(number, clazz);
            }
            BigInteger bigInteger = BigInteger.valueOf(number.longValue());
            return (N)((Number)clazz.cast(var2_17));
        } else if (clazz == BigDecimal.class) {
            BigDecimal bigDecimal = NumberConvertor.toBigDecimal(number);
            return (N)((Number)clazz.cast(var2_17));
        } else if (clazz == Double.class) {
            if (!(number instanceof Byte || number instanceof Short || number instanceof Integer || number instanceof AtomicInteger || number instanceof Long || number instanceof AtomicLong || number instanceof Float)) {
                if (!(number instanceof BigInteger)) throw new IllegalStateException("Unknown class " + number.getClass());
                BigInteger bigInteger = (BigInteger)number;
                if (bigInteger.compareTo(MAX_DOUBLE.toBigIntegerExact()) > 0 || bigInteger.compareTo(MIN_DOUBLE.toBigIntegerExact()) < 0) {
                    throw new OverflowException(number, clazz);
                }
            }
            Double d = number.doubleValue();
            return (N)((Number)clazz.cast(var2_17));
        } else {
            if (clazz != Float.class) throw new IllegalArgumentException("Unknown class: " + clazz);
            if (!(number instanceof Byte || number instanceof Short || number instanceof Integer || number instanceof AtomicInteger || number instanceof Long || number instanceof AtomicLong)) {
                if (number instanceof Double) {
                    if (Math.abs(number.doubleValue()) > 3.4028234663852886E38) {
                        throw new OverflowException(number, clazz);
                    }
                } else {
                    if (!(number instanceof BigInteger)) throw new IllegalStateException("Unknown class " + number.getClass());
                    BigInteger bigInteger = (BigInteger)number;
                    if (bigInteger.compareTo(MAX_FLOAT.toBigIntegerExact()) > 0 || bigInteger.compareTo(MIN_FLOAT.toBigIntegerExact()) < 0) {
                        throw new OverflowException(number, clazz);
                    }
                }
            }
            Float f = Float.valueOf(number.floatValue());
        }
        return (N)((Number)clazz.cast(var2_17));
    }

    public static class RoundingException
    extends ArithmeticException {
        public RoundingException(Number number, Class<? extends Number> clazz) {
            super("Rounding necessary for " + clazz + " : " + number + " (" + number.getClass() + ")");
        }
    }

    public static class OverflowException
    extends ArithmeticException {
        public OverflowException(Number number, Class<? extends Number> clazz) {
            super("Cannot convert to " + clazz + " : " + number);
        }

        @Override
        public OverflowException initCause(Throwable throwable) {
            super.initCause(throwable);
            return this;
        }
    }
}

