/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;

public class TimeUtils {
    private static DatatypeFactory typeFactory = null;

    public static final DatatypeFactory getTypeFactory() {
        if (typeFactory == null) {
            try {
                typeFactory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                throw new IllegalStateException(datatypeConfigurationException);
            }
        }
        return typeFactory;
    }

    public static final Duration timePartToDuration(Calendar calendar) {
        BigDecimal bigDecimal = BigDecimal.valueOf(calendar.get(13)).add(BigDecimal.valueOf(calendar.get(14)).movePointLeft(3));
        return TimeUtils.getTypeFactory().newDuration(true, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.valueOf(calendar.get(11)), BigInteger.valueOf(calendar.get(12)), bigDecimal);
    }

    public static final long normalizeLocalTime(Calendar calendar) {
        return calendar.getTimeInMillis() + (long)calendar.getTimeZone().getOffset(calendar.getTimeInMillis());
    }

    public static final Calendar copyLocalTime(Calendar calendar, Calendar calendar2) {
        calendar2.clear();
        for (int n : new int[]{1, 6, 11, 12, 13, 14}) {
            calendar2.set(n, calendar.get(n));
        }
        return calendar2;
    }
}

