/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util;

import java.awt.Color;

public class FillMode {
    public static final FillMode STRETCH = new FillMode(false);
    public static final FillMode ZOOM_CENTER = new ZoomIn(0);
    public static final FillMode ZOOM_LEADING = new ZoomIn(10);
    public static final FillMode ZOOM_TRAILING = new ZoomIn(11);
    private final boolean keepRatio;

    protected FillMode(boolean bl) {
        this.keepRatio = bl;
    }

    public final boolean isRatioKept() {
        return this.keepRatio;
    }

    public static class ZoomIn
    extends FillMode {
        private final int position;

        public ZoomIn(int n) {
            super(true);
            if (n != 0 && n != 10 && n != 11) {
                throw new IllegalArgumentException("Neither center, leading nor trailing");
            }
            this.position = n;
        }

        public final int getPosition() {
            return this.position;
        }

        public final int getPosition(int n, int n2) {
            int n3;
            if (n < n2) {
                throw new IllegalArgumentException("External < Internal : " + n + " < " + n2);
            }
            if (this.getPosition() == 0) {
                n3 = (n - n2) / 2;
            } else if (this.getPosition() == 10) {
                n3 = 0;
            } else if (this.getPosition() == 11) {
                n3 = n - n2;
            } else {
                throw new IllegalStateException("Unkwown position");
            }
            return n3;
        }
    }

    public static class ZoomOut
    extends FillMode {
        private final Color bg;

        public ZoomOut(Color color) {
            super(true);
            this.bg = color;
        }

        public final Color getBackgroundColor() {
            return this.bg;
        }
    }
}

