/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.sample;

import com.lowagie.text.Document;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDocument;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Graphics2D;
import java.io.File;
import java.io.FileOutputStream;
import org.jopendocument.model.OpenDocument;
import org.jopendocument.renderer.ODTRenderer;

public class SimplePDFGenerator {
    public static void main(String[] stringArray) {
        long l = System.nanoTime();
        try {
            OpenDocument openDocument = new OpenDocument();
            openDocument.loadFrom("template/invoice.ods");
            Document document = new Document(PageSize.A4);
            File file = new File("invoice.pdf");
            PdfDocument pdfDocument = new PdfDocument();
            document.addDocListener(pdfDocument);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            PdfWriter pdfWriter = PdfWriter.getInstance(pdfDocument, fileOutputStream);
            pdfDocument.addWriter(pdfWriter);
            document.open();
            Rectangle rectangle = document.getPageSize();
            int n = (int)((double)rectangle.getWidth() * 0.9);
            int n2 = (int)((double)rectangle.getHeight() * 0.95);
            PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
            PdfTemplate pdfTemplate = pdfContentByte.createTemplate(n, n2);
            Graphics2D graphics2D = pdfTemplate.createPrinterGraphics(n, n2, null);
            pdfTemplate.setWidth(n);
            pdfTemplate.setHeight(n2);
            ODTRenderer oDTRenderer = new ODTRenderer(openDocument);
            oDTRenderer.setIgnoreMargins(true);
            oDTRenderer.setPaintMaxResolution(true);
            oDTRenderer.setResizeFactor(oDTRenderer.getPrintWidth() / (double)n);
            oDTRenderer.paintComponent(graphics2D);
            graphics2D.dispose();
            float f = (rectangle.getWidth() - (float)n) / 2.0f;
            float f2 = (rectangle.getHeight() - (float)n2) / 2.0f;
            pdfContentByte.addTemplate(pdfTemplate, f, f2);
            document.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        long l2 = System.nanoTime();
        System.out.println("Time:" + (l2 - l) / 1000000L + " ms");
    }
}

