/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.text;

import java.awt.Color;
import java.util.Arrays;
import org.jdom.Element;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.OOUtils;
import org.jopendocument.dom.Style;
import org.jopendocument.dom.StyleProperties;
import org.jopendocument.dom.StyleStyle;
import org.jopendocument.dom.StyleStyleDesc;
import org.jopendocument.dom.XMLVersion;

public class TextStyle
extends StyleStyle {
    public static final StyleStyleDesc<TextStyle> DESC = new StyleStyleDesc<TextStyle>(TextStyle.class, XMLVersion.OD, "text", "T"){
        {
            this.getRefElementsMap().putAll((Object)"text:style-name", Arrays.asList("text:linenumbering-configuration", "text:list-level-style-number", "text:ruby-text", "text:span"));
        }

        @Override
        public TextStyle create(ODPackage oDPackage, Element element) {
            return new TextStyle(oDPackage, element);
        }
    };
    private StyleTextProperties textProps = null;

    public TextStyle(ODPackage oDPackage, Element element) {
        super(oDPackage, element);
    }

    public final StyleTextProperties getTextProperties() {
        if (this.textProps == null) {
            this.textProps = new StyleTextProperties(this);
        }
        return this.textProps;
    }

    public final Color getColor() {
        return this.getTextProperties().getColor();
    }

    public final Color getBackgroundColor() {
        return this.getTextProperties().getBackgroundColor();
    }

    public static class StyleTextProperties
    extends StyleProperties {
        public StyleTextProperties(Style style) {
            super(style, DESC.getFamily());
        }

        public final Color getColor() {
            return OOUtils.decodeRGB(this.getAttributeValue("color", this.getNS("fo")));
        }

        public final void setColor(Color color) {
            this.getElement().setAttribute("color", OOUtils.encodeRGB(color), this.getNS("fo"));
        }

        public final String getFontName() {
            return this.getAttributeValue("font-name", this.getElement().getNamespace("style"));
        }

        public final String getLanguage() {
            return this.getAttributeValue("language", this.getNS("fo"));
        }

        public final String getCountry() {
            return this.getAttributeValue("country", this.getNS("fo"));
        }

        public final String getWeight() {
            return this.getAttributeValue("font-weight", this.getNS("fo"));
        }
    }
}

