/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.text;

import java.io.File;
import java.io.IOException;
import org.jdom.Element;
import org.jopendocument.dom.ContentType;
import org.jopendocument.dom.ContentTypeVersioned;
import org.jopendocument.dom.ODDocument;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.XMLFormatVersion;
import org.jopendocument.dom.text.Paragraph;
import org.jopendocument.dom.text.TextNode;

public class TextDocument
extends ODDocument {
    public static TextDocument createFromFile(File file) throws IOException {
        return new ODPackage(file).getTextDocument();
    }

    public static TextDocument get(ODPackage oDPackage) {
        return oDPackage.hasODDocument() ? oDPackage.getTextDocument() : new TextDocument(oDPackage);
    }

    public static TextDocument createEmpty(String string) throws IOException {
        return TextDocument.createEmpty(string, XMLFormatVersion.getDefault());
    }

    public static TextDocument createEmpty(String string, XMLFormatVersion xMLFormatVersion) throws IOException {
        ContentTypeVersioned contentTypeVersioned = ContentType.TEXT.getVersioned(xMLFormatVersion.getXMLVersion());
        TextDocument textDocument = contentTypeVersioned.createPackage(xMLFormatVersion).getTextDocument();
        Element element = Paragraph.createEmpty(xMLFormatVersion.getXMLVersion());
        element.addContent(string);
        textDocument.getBody().addContent(element);
        return textDocument;
    }

    private TextDocument(ODPackage oDPackage) {
        super(oDPackage);
    }

    public final Paragraph getParagraph(int n) {
        Element element = Paragraph.createEmpty(this.getVersion());
        Element element2 = (Element)this.getBody().getChildren(element.getName(), element.getNamespace()).get(n);
        return new Paragraph(element2, this);
    }

    public synchronized void add(TextNode<?> textNode) {
        this.add(textNode, null, -1);
    }

    public synchronized void add(TextNode<?> textNode, Element element, int n) {
        Element element2;
        Element element3 = element2 = element == null ? this.getBody() : element;
        if (n < 0) {
            element2.addContent(textNode.getElement());
        } else {
            element2.addContent(n, textNode.getElement());
        }
        try {
            textNode.setDocument(this);
        }
        catch (RuntimeException runtimeException) {
            textNode.getElement().detach();
            throw runtimeException;
        }
    }
}

