/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.style.data;

import java.util.List;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.ODValueType;
import org.jopendocument.dom.XMLVersion;
import org.jopendocument.dom.spreadsheet.CellStyle;
import org.jopendocument.dom.style.data.DataStyle;
import org.jopendocument.dom.style.data.NumberStyle;

public class PercentStyle
extends DataStyle {
    public static final DataStyle.DataStyleDesc<PercentStyle> DESC = new DataStyle.DataStyleDesc<PercentStyle>(PercentStyle.class, XMLVersion.OD, "percentage-style", "N"){

        @Override
        public PercentStyle create(ODPackage oDPackage, Element element) {
            return new PercentStyle(oDPackage, element);
        }
    };

    public PercentStyle(ODPackage oDPackage, Element element) {
        super(oDPackage, element, ODValueType.PERCENTAGE);
    }

    @Override
    protected Object convertNonNull(Object object) {
        return NumberStyle.toNumber(object, this.getEpoch());
    }

    @Override
    public String format(Object object, CellStyle cellStyle, boolean bl) {
        Number number = (Number)object;
        Namespace namespace = this.getElement().getNamespace();
        StringBuilder stringBuilder = new StringBuilder();
        List list = this.getElement().getChildren();
        for (Element element : list) {
            if (!element.getNamespace().equals(namespace)) continue;
            if (element.getName().equals("text")) {
                stringBuilder.append(element.getText());
                continue;
            }
            if (!element.getName().equals("number")) continue;
            stringBuilder.append(this.formatNumberOrScientificNumber(element, number, 100, cellStyle));
        }
        return stringBuilder.toString();
    }
}

