/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.style.data;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jopendocument.dom.Log;
import org.jopendocument.dom.ODEpoch;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.ODValueType;
import org.jopendocument.dom.Style;
import org.jopendocument.dom.StyleDesc;
import org.jopendocument.dom.StyleProperties;
import org.jopendocument.dom.XMLVersion;
import org.jopendocument.dom.spreadsheet.CellStyle;
import org.jopendocument.dom.style.data.BooleanStyle;
import org.jopendocument.dom.style.data.CurrencyStyle;
import org.jopendocument.dom.style.data.DateStyle;
import org.jopendocument.dom.style.data.NumberStyle;
import org.jopendocument.dom.style.data.PercentStyle;
import org.jopendocument.dom.style.data.TextStyle;
import org.jopendocument.dom.style.data.TimeStyle;
import org.jopendocument.dom.text.TextStyle;
import org.jopendocument.util.NumberUtils;

public abstract class DataStyle
extends Style {
    private static final int DEFAULT_GROUPING_SIZE = new DecimalFormat().getGroupingSize();
    private static final int DEFAULT_DECIMAL_PLACES = 2;
    private static final Pattern QUOTE_PATRN = Pattern.compile("'", 16);
    private static final Pattern EXP_PATTERN = Pattern.compile("E(\\d+)$");
    public static final DataStyleDesc<?>[] DATA_STYLES_DESCS = new DataStyleDesc[]{NumberStyle.DESC, PercentStyle.DESC, TextStyle.DESC, CurrencyStyle.DESC, DateStyle.DESC, TimeStyle.DESC, BooleanStyle.DESC};
    private final ODValueType type;
    private TextStyle.StyleTextProperties textProps;

    public static int getDecimalPlaces(CellStyle cellStyle) {
        int n = cellStyle != null && cellStyle.getTableCellProperties().getDecimalPlaces() != null ? cellStyle.getTableCellProperties().getDecimalPlaces() : 2;
        return n;
    }

    public static void addStringLiteral(StringBuilder stringBuilder, String string) {
        stringBuilder.append('\'');
        stringBuilder.append(QUOTE_PATRN.matcher(string).replaceAll("''"));
        stringBuilder.append('\'');
    }

    protected DataStyle(ODPackage oDPackage, Element element, ODValueType oDValueType) {
        super(oDPackage, element);
        this.type = oDValueType;
    }

    public final ODValueType getDataType() {
        return this.type;
    }

    public final ODEpoch getEpoch() {
        return this.getPackage().getODDocument().getEpoch();
    }

    public final Object convert(Object object) throws NullPointerException {
        if (object == null) {
            throw new NullPointerException();
        }
        Object object2 = this.canFormat(object.getClass()) ? object : this.convertNonNull(object);
        assert (object2 == null || this.canFormat(object2.getClass()));
        return object2;
    }

    protected abstract Object convertNonNull(Object var1);

    public final boolean canFormat(Class<?> clazz) {
        return this.getDataType().canFormat(clazz);
    }

    public final String getTitle() {
        return this.getElement().getAttributeValue("title", this.getElement().getNamespace());
    }

    public final TextStyle.StyleTextProperties getTextProperties() {
        if (this.textProps == null) {
            this.textProps = new TextStyle.StyleTextProperties(this);
        }
        return this.textProps;
    }

    public abstract String format(Object var1, CellStyle var2, boolean var3) throws UnsupportedOperationException;

    protected final void reportError(String string, boolean bl) throws UnsupportedOperationException {
        if (!bl) {
            throw new UnsupportedOperationException(string);
        }
        Log.get().warning(string);
    }

    protected final String formatNumberOrScientificNumber(Element element, Number number, CellStyle cellStyle) {
        return this.formatNumberOrScientificNumber(element, number, 1, cellStyle);
    }

    protected final String formatNumberOrScientificNumber(Element element, Number number, int n, CellStyle cellStyle) {
        Matcher matcher;
        int n2;
        Attribute attribute;
        boolean bl;
        int n3;
        Namespace namespace = this.getElement().getNamespace();
        StringBuilder stringBuilder = new StringBuilder();
        List list = element.getChildren("embedded-text", namespace);
        TreeMap treeMap = new TreeMap(Collections.reverseOrder());
        for (Object e : list) {
            Element element2 = (Element)e;
            treeMap.put(Integer.valueOf(element2.getAttributeValue("position", namespace)), element2.getText());
        }
        Attribute attribute2 = element.getAttribute("display-factor", namespace);
        double d = (attribute2 != null ? Double.valueOf(attribute2.getValue()) : 1.0) / (double)n;
        boolean bl2 = StyleProperties.parseBoolean(element.getAttributeValue("grouping", namespace), false);
        String string = element.getAttributeValue("min-integer-digits", namespace);
        int n4 = n3 = string == null ? 0 : Integer.parseInt(string);
        if (n3 == 0) {
            stringBuilder.append('#');
        } else {
            for (int i = 0; i < n3; ++i) {
                stringBuilder.append('0');
            }
        }
        String string2 = element.getAttributeValue("decimal-replacement", namespace);
        if (string2 != null && !NumberUtils.hasFractionalPart(number)) {
            bl = true;
            stringBuilder.append('.');
            DataStyle.addStringLiteral(stringBuilder, string2);
        } else {
            bl = false;
            attribute = element.getAttribute("decimal-places", namespace);
            n2 = attribute != null ? Integer.parseInt(attribute.getValue()) : DataStyle.getDecimalPlaces(cellStyle);
            if (n2 > 0) {
                stringBuilder.append('.');
                for (int i = 0; i < n2; ++i) {
                    stringBuilder.append('0');
                }
            }
        }
        attribute = element.getAttribute("min-exponent-digits", namespace);
        if (attribute != null) {
            stringBuilder.append('E');
            for (n2 = 0; n2 < Integer.parseInt(attribute.getValue()); ++n2) {
                stringBuilder.append('0');
            }
        }
        DecimalFormat decimalFormat = new DecimalFormat(stringBuilder.toString());
        decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
        decimalFormat.setGroupingUsed(bl2);
        decimalFormat.setGroupingSize(DEFAULT_GROUPING_SIZE);
        decimalFormat.setDecimalSeparatorAlwaysShown(bl);
        String string3 = decimalFormat.format(NumberUtils.divide(number, d));
        if (attribute != null && (matcher = EXP_PATTERN.matcher(string3)).find()) {
            string3 = string3.substring(0, matcher.start()) + "E+" + matcher.group(1);
        }
        if (treeMap.size() > 0) {
            int n5 = Math.max(n3, NumberUtils.intDigits(number));
            int n6 = 0;
            for (Map.Entry entry : treeMap.entrySet()) {
                String string4 = (String)entry.getValue();
                int n7 = Math.max(0, n6 + n5 - (Integer)entry.getKey());
                string3 = string3.substring(0, n7) + string4 + string3.substring(n7);
                n6 += string4.length();
            }
        }
        return string3;
    }

    public static abstract class DataStyleDesc<S extends DataStyle>
    extends StyleDesc<S> {
        protected DataStyleDesc(Class<S> clazz, XMLVersion xMLVersion, String string, String string2) {
            super(clazz, xMLVersion, string, string2);
            this.setElementNS(this.getVersion().getNS("number"));
            this.getRefElementsMap().putAll((Object)"style:data-style-name", Arrays.asList("presentation:date-time-decl", "style:style", "text:creation-date", "text:creation-time", "text:database-display", "text:date", "text:editing-duration", "text:expression", "text:meta-field", "text:modification-date", "text:modification-time", "text:print-date", "text:print-time", "text:table-formula", "text:time", "text:user-defined", "text:user-field-get", "text:user-field-input", "text:variable-get", "text:variable-input", "text:variable-set"));
            this.getRefElementsMap().put((Object)"style:apply-style-name", (Object)"style:map");
        }
    }
}

