/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.spreadsheet;

import java.math.BigDecimal;
import java.util.Arrays;
import org.jdom.Element;
import org.jopendocument.dom.LengthUnit;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.StyleStyle;
import org.jopendocument.dom.StyleStyleDesc;
import org.jopendocument.dom.XMLVersion;
import org.jopendocument.dom.style.SideStyleProperties;

public class TableStyle
extends StyleStyle {
    public static final LengthUnit DEFAULT_UNIT = LengthUnit.MM;
    public static final StyleStyleDesc<TableStyle> DESC = new StyleStyleDesc<TableStyle>(TableStyle.class, XMLVersion.OD, "table", "ta", "table", Arrays.asList("table:background", "table:table")){

        @Override
        public TableStyle create(ODPackage oDPackage, Element element) {
            return new TableStyle(oDPackage, element);
        }
    };
    private StyleTableProperties tableProps;

    public TableStyle(ODPackage oDPackage, Element element) {
        super(oDPackage, element);
    }

    public final StyleTableProperties getTableProperties() {
        if (this.tableProps == null) {
            this.tableProps = new StyleTableProperties(this);
        }
        return this.tableProps;
    }

    public final Float getWidth() {
        BigDecimal bigDecimal = this.getTableProperties().getWidth(DEFAULT_UNIT);
        return bigDecimal == null ? null : Float.valueOf(bigDecimal.floatValue());
    }

    void setWidth(float f) {
        this.getFormattingProperties().setAttribute("width", f + DEFAULT_UNIT.getSymbol(), this.getSTYLE());
    }

    public static class StyleTableProperties
    extends SideStyleProperties {
        public StyleTableProperties(StyleStyle styleStyle) {
            super(styleStyle, styleStyle.getFamily());
        }

        public final String getRawMargin(SideStyleProperties.Side side) {
            return this.getSideAttribute(side, "margin", this.getNS("fo"));
        }

        public final BigDecimal getMargin(SideStyleProperties.Side side, LengthUnit lengthUnit) {
            return LengthUnit.parseLength(this.getRawMargin(side), lengthUnit);
        }

        public final BigDecimal getWidth(LengthUnit lengthUnit) {
            return LengthUnit.parseLength(this.getAttributeValue("width", this.getNS("style")), lengthUnit);
        }
    }
}

