/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.spreadsheet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jopendocument.dom.ODNode;
import org.jopendocument.dom.StyleProperties;
import org.jopendocument.dom.spreadsheet.Axis;
import org.jopendocument.dom.spreadsheet.Table;
import org.jopendocument.util.Tuple2;

public class TableGroup
extends ODNode {
    private final Table<?> table;
    private final Axis axis;
    private final TableGroup parent;
    private final List<TableGroup> children;
    private int headerCount;
    private int first;
    private int size;

    static Tuple2<TableGroup, List<Element>> createRoot(Table<?> table, Axis axis) {
        TableGroup tableGroup = new TableGroup(table, axis);
        return Tuple2.create(tableGroup, tableGroup.flatten());
    }

    private TableGroup(Table<?> table, Axis axis) {
        this(table, axis, null, table.getElement(), 0);
    }

    private TableGroup(Table<?> table, TableGroup tableGroup, Element element, int n) {
        this(table, tableGroup.axis, tableGroup, element, n);
    }

    private TableGroup(Table<?> table, Axis axis, TableGroup tableGroup, Element element, int n) {
        super(element);
        if (table == null) {
            throw new NullPointerException("null table");
        }
        this.table = table;
        this.axis = axis;
        this.parent = tableGroup;
        this.first = n;
        this.children = new ArrayList<TableGroup>();
    }

    private List<Element> flatten() {
        ArrayList<Element> arrayList = new ArrayList<Element>(Math.max(128, this.getElement().getContentSize()));
        String string = this.axis.getElemName();
        String string2 = this.axis.getGroupName();
        String string3 = this.axis.getPluralName();
        Element element = this.getElement().getChild(this.axis.getHeaderName(), this.getElement().getNamespace());
        this.headerCount = element != null ? Table.flattenChildren(arrayList, element, this.axis) : 0;
        int n = this.headerCount;
        this.children.clear();
        ArrayList arrayList2 = new ArrayList(this.getElement().getChildren());
        for (Element element2 : arrayList2) {
            if (element2.getName().equals(string)) {
                n += Table.flatten1(arrayList, element2, this.axis);
                continue;
            }
            if (element2.getName().equals(string3)) {
                n += Table.flattenChildren(arrayList, element2, this.axis);
                continue;
            }
            if (!element2.getName().equals(string2)) continue;
            TableGroup tableGroup = new TableGroup(this.getTable(), this, element2, this.first + n);
            this.children.add(tableGroup);
            arrayList.addAll(tableGroup.flatten());
            n += tableGroup.getSize();
        }
        this.size = n;
        return arrayList;
    }

    public final Table<?> getTable() {
        return this.table;
    }

    public final TableGroup getParent() {
        return this.parent;
    }

    public final List<TableGroup> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    final TableGroup getDescendentOrSelfContaining(int n) {
        if (!this.contains(n)) {
            return null;
        }
        for (TableGroup tableGroup : this.getChildren()) {
            TableGroup tableGroup2 = tableGroup.getDescendentOrSelfContaining(n);
            if (tableGroup2 == null) continue;
            return tableGroup2;
        }
        return this;
    }

    public final boolean isDisplayed() {
        if (this.getParent() == null) {
            return true;
        }
        return StyleProperties.parseBoolean(this.getElement().getAttributeValue("display", this.getElement().getNamespace()), true);
    }

    public final int getFirst() {
        return this.first;
    }

    public final int getHeaderCount() {
        return this.headerCount;
    }

    public final int getSize() {
        return this.size;
    }

    public final boolean contains(int n) {
        return n >= this.getFirst() && n < this.getFirst() + this.getSize();
    }

    final int getFollowingHeaderCount() {
        int n = this.getHeaderCount();
        for (TableGroup tableGroup : this.getChildren()) {
            if (tableGroup.getFirst() != this.getFirst() + n) break;
            n += tableGroup.getFollowingHeaderCount();
        }
        return n;
    }
}

