/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.spreadsheet;

import java.awt.Point;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import javax.swing.table.TableModel;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jopendocument.dom.LengthUnit;
import org.jopendocument.dom.ODDocument;
import org.jopendocument.dom.Style;
import org.jopendocument.dom.StyleDesc;
import org.jopendocument.dom.StyleStyleDesc;
import org.jopendocument.dom.XMLVersion;
import org.jopendocument.dom.spreadsheet.Axis;
import org.jopendocument.dom.spreadsheet.Cell;
import org.jopendocument.dom.spreadsheet.CellStyle;
import org.jopendocument.dom.spreadsheet.Column;
import org.jopendocument.dom.spreadsheet.ColumnStyle;
import org.jopendocument.dom.spreadsheet.MutableCell;
import org.jopendocument.dom.spreadsheet.Range;
import org.jopendocument.dom.spreadsheet.RepeatedBreaker;
import org.jopendocument.dom.spreadsheet.Row;
import org.jopendocument.dom.spreadsheet.RowStyle;
import org.jopendocument.dom.spreadsheet.Sheet;
import org.jopendocument.dom.spreadsheet.SheetTableModel;
import org.jopendocument.dom.spreadsheet.SpreadSheet;
import org.jopendocument.dom.spreadsheet.TableCalcNode;
import org.jopendocument.dom.spreadsheet.TableGroup;
import org.jopendocument.dom.spreadsheet.TableStyle;
import org.jopendocument.util.CollectionUtils;
import org.jopendocument.util.JDOMUtils;
import org.jopendocument.util.SimpleXMLPath;
import org.jopendocument.util.Tuple2;

public class Table<D extends ODDocument>
extends TableCalcNode<TableStyle, D> {
    private final ArrayList<Row<D>> rows = new ArrayList(64);
    private TableGroup rowGroup;
    private final ArrayList<Column<D>> cols = new ArrayList(32);
    private TableGroup columnGroup;

    static Element createEmpty(XMLVersion xMLVersion) {
        Element element = Column.createEmpty(xMLVersion, null);
        Element element2 = Row.createEmpty(xMLVersion).addContent(Cell.createEmpty(xMLVersion));
        return new Element("table", xMLVersion.getTABLE()).addContent(element).addContent(element2);
    }

    static final String getName(Element element) {
        return element.getAttributeValue("name", element.getNamespace("table"));
    }

    public Table(D d, Element element) {
        super(d, element, TableStyle.class);
        this.readColumns();
        this.readRows();
    }

    private void readColumns() {
        this.read(Axis.COLUMN);
    }

    private final void readRows() {
        this.read(Axis.ROW);
    }

    private final void read(Axis axis) {
        boolean bl = axis == Axis.COLUMN;
        Tuple2<TableGroup, List<Element>> tuple2 = TableGroup.createRoot(this, axis);
        ArrayList<TableCalcNode> arrayList = bl ? this.cols : this.rows;
        int n = arrayList.size();
        arrayList.clear();
        int n2 = tuple2.get0().getSize();
        arrayList.ensureCapacity(n2);
        if (bl) {
            StyleStyleDesc<ColumnStyle> styleStyleDesc = this.getColumnStyleDesc();
            for (Element element : tuple2.get1()) {
                this.addCol(element, styleStyleDesc);
            }
            this.columnGroup = tuple2.get0();
        } else {
            StyleStyleDesc<RowStyle> styleStyleDesc = this.getRowStyleDesc();
            StyleStyleDesc<CellStyle> styleStyleDesc2 = this.getCellStyleDesc();
            for (Element element : tuple2.get1()) {
                this.addRow(element, styleStyleDesc, styleStyleDesc2);
            }
            this.rowGroup = tuple2.get0();
        }
        if (n - n2 > 8192) {
            arrayList.trimToSize();
        }
        assert (n2 == (bl ? this.getColumnCount() : this.getRowCount()));
    }

    private final void addCol(Element element, StyleStyleDesc<ColumnStyle> styleStyleDesc) {
        this.cols.add(new Column(this, element, styleStyleDesc));
    }

    static final int flattenChildren(List<Element> list, Element element, Axis axis) {
        int n = 0;
        int[] nArray = new int[]{0};
        ArrayList arrayList = new ArrayList(element.getChildren(axis.getElemName(), element.getNamespace()));
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            Element element2 = (Element)arrayList.get(i);
            n += Table.flatten1(list, element2, axis, nArray);
        }
        return n;
    }

    static int flatten1(List<Element> list, Element element, Axis axis) {
        return Table.flatten1(list, element, axis, null);
    }

    private static int flatten1(List<Element> list, Element element, Axis axis, int[] nArray) {
        int n;
        int n2 = list.size();
        Attribute attribute = axis.getRepeatedAttr(element);
        int n3 = n = attribute == null ? 1 : Integer.parseInt(attribute.getValue());
        if (axis == Axis.COLUMN && n > 1) {
            element.removeAttribute(attribute);
            Element element2 = element.getParentElement();
            int n4 = (nArray == null ? element2.indexOf(element) : nArray[0]) + 1;
            list.add(element);
            for (int i = 0; i < n - 1; ++i) {
                Element element3 = (Element)element.clone();
                list.add(element3);
                element2.addContent(n4 + i, element3);
            }
        } else {
            list.add(element);
        }
        if (nArray != null) {
            nArray[0] = nArray[0] + (list.size() - n2);
        }
        return n;
    }

    public final String getName() {
        return Table.getName(this.getElement());
    }

    public final void setName(String string) {
        this.getElement().setAttribute("name", string, ((ODDocument)this.getODDocument()).getVersion().getTABLE());
    }

    public void detach() {
        this.getElement().detach();
    }

    public final Object getPrintRanges() {
        return this.getElement().getAttributeValue("print-ranges", this.getTABLE());
    }

    public final void setPrintRanges(String string) {
        this.getElement().setAttribute("print-ranges", string, this.getTABLE());
    }

    public final void removePrintRanges() {
        this.getElement().removeAttribute("print-ranges", this.getTABLE());
    }

    public final synchronized void duplicateFirstRows(int n, int n2) {
        this.duplicateRows(0, n, n2);
    }

    public final synchronized void insertDuplicatedRows(int n, int n2) {
        this.duplicateRows(n, 1, n2);
    }

    public final synchronized void duplicateRows(int n, int n2, int n3) {
        this.duplicateRows(n, n2, n3, true);
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void duplicateRows(int n, int n2, int n3, boolean bl) {
        void simpleXMLPath;
        Object object;
        Row<D> row2;
        int n4;
        int n5 = n + n2;
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n6 = this.getColumnCount();
        for (int i = 0; i < n6; ++i) {
            n4 = n;
            while (n4 < n5) {
                int n7;
                row2 = this.getCoverOrigin(i, n4);
                if (row2 == null) {
                    ++n4;
                    continue;
                }
                if (hashMap.containsKey(row2)) {
                    n7 = (Integer)hashMap.get(row2);
                } else {
                    object = this.getImmutableCellAt(((Point)((Object)row2)).x, ((Point)((Object)row2)).y);
                    n7 = ((Point)((Object)row2)).y + ((Cell)object).getRowsSpanned() - 1;
                    if (((Point)((Object)row2)).y < n) {
                        if (n7 < n5 - 1) {
                            throw new IllegalArgumentException("Span starts before the duplicated rows and doesn't extend past the end of duplicated rows at " + Table.getAddress((Point)((Object)row2)));
                        }
                    } else if (n7 > n5 - 1) {
                        throw new IllegalArgumentException("Span starts in the duplicated rows and extend past the end of duplicated rows at " + Table.getAddress((Point)((Object)row2)));
                    }
                    hashMap.put(row2, n7);
                    if (((Point)((Object)row2)).y < n || n7 > n5 - 1) {
                        arrayList.add(row2);
                    }
                }
                n4 = n7 + 1;
            }
        }
        ArrayList<Element> arrayList2 = new ArrayList<Element>(n2 * n3);
        for (n4 = n; n4 < n5; n4 += simpleXMLPath.getRepeated()) {
            row2 = this.getRow(n4);
            if (row2.getY() < n4) {
                Row<D> row = this.getMutableRow(n4);
            } else {
                assert (row2.getY() == n4);
                if (row2.getLastY() >= n5) {
                    assert (this.getRow(n5) == row2);
                    this.getMutableRow(n5);
                    Row<D> j = this.getRow(n4);
                } else {
                    Row<D> point = row2;
                }
            }
            assert (simpleXMLPath.getY() == n4);
            assert (simpleXMLPath.getLastY() < n5) : "Row goes to far";
            arrayList2.add((Element)simpleXMLPath.getElement().clone());
        }
        n4 = arrayList2.size();
        for (int i = 1; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                arrayList2.add((Element)((Element)arrayList2.get(j)).clone());
            }
        }
        assert (this.getRow(n5 - 1).getLastY() == n5 - 1) : "Adding XML element too far";
        JDOMUtils.insertAfter(this.getRow(n5 - 1).getElement(), arrayList2);
        for (Point point : arrayList) {
            object = this.getCellAt(point);
            ((MutableCell)object).setRowsSpanned(((Cell)object).getRowsSpanned() + n2 * n3);
        }
        this.readRows();
        if (bl && this.getODDocument() instanceof SpreadSheet) {
            SpreadSheet spreadSheet = (SpreadSheet)this.getODDocument();
            SimpleXMLPath<Attribute> simpleXMLPath2 = SimpleXMLPath.allAttributes("end-cell-address", "table");
            for (Attribute attribute : simpleXMLPath2.selectNodes(this.getElement())) {
                int n7;
                Tuple2<Sheet, Point> tuple2 = spreadSheet.resolve(attribute.getValue());
                Sheet sheet = tuple2.get0();
                if (sheet != this) {
                    throw new UnsupportedOperationException("End sheet is not this : " + sheet);
                }
                Point point = tuple2.get1();
                if (point.y < n) continue;
                Element element = attribute.getParent();
                Element element2 = JDOMUtils.getAncestor(element, "table-row", this.getTABLE());
                if (element2 == null) {
                    throw new IllegalStateException("Not in a row : " + JDOMUtils.output(element));
                }
                int n8 = -1;
                int n9 = this.getRowCount();
                for (n7 = 0; n7 < n9; ++n7) {
                    if (this.getRow(n7).getElement() != element2) continue;
                    n8 = n7;
                    break;
                }
                if (n8 < 0) {
                    throw new IllegalStateException("Row not found for " + JDOMUtils.output(element));
                }
                if (n8 >= n + (n3 + 1) * n2) {
                    n7 = point.y + n3 * n2;
                } else if (n8 >= n + n2 && point.y < n + n2) {
                    int n10 = (n8 - n) / n2;
                    n7 = point.y + n10 * n2;
                } else {
                    LengthUnit lengthUnit = LengthUnit.MM;
                    BigDecimal[] bigDecimalArray = ((ODDocument)this.getODDocument()).getFormatVersion().getXML().getCoordinates(element, lengthUnit, false, true);
                    if (bigDecimalArray == null) {
                        throw new IllegalStateException("Couldn't find the height of the shape : " + JDOMUtils.output(element));
                    }
                    BigDecimal bigDecimal = bigDecimalArray[3];
                    assert (bigDecimal != null) : "getCoordinates() should never return null BigDecimal (unless requested by horizontal/vertical)";
                    int n11 = n8;
                    BigDecimal bigDecimal2 = ((RowStyle)this.getRow(n11).getStyle()).getTableRowProperties().getHeight(lengthUnit);
                    while (bigDecimal.compareTo(bigDecimal2) > 0) {
                        bigDecimal2 = bigDecimal2.add(((RowStyle)this.getRow(++n11).getStyle()).getTableRowProperties().getHeight(lengthUnit));
                    }
                    BigDecimal bigDecimal3 = bigDecimal2.subtract(((RowStyle)this.getRow(n11).getStyle()).getTableRowProperties().getHeight(lengthUnit));
                    BigDecimal bigDecimal4 = bigDecimal.subtract(bigDecimal3);
                    assert (bigDecimal4.signum() >= 0);
                    n7 = n11;
                    element.setAttribute("end-y", lengthUnit.format(bigDecimal4), this.getTABLE());
                }
                attribute.setValue(SpreadSheet.formatSheetName(sheet.getName()) + "." + Table.getAddress(new Point(point.x, n7)));
            }
        }
    }

    private synchronized void addRow(Element element, StyleDesc<RowStyle> styleDesc, StyleDesc<CellStyle> styleDesc2) {
        Row row = new Row(this, element, this.rows.size(), styleDesc, styleDesc2);
        int n = row.getRepeated();
        for (int i = 0; i < n; ++i) {
            this.rows.add(row);
        }
    }

    public final Point resolveHint(String string) {
        Point point = Table.resolve(string);
        if (point != null) {
            return point;
        }
        throw new IllegalArgumentException(string + " is not a cell ref, if it's a named range, you must use it on a SpreadSheet.");
    }

    public final boolean isCellValid(int n, int n2) {
        if (n > this.getColumnCount()) {
            return false;
        }
        if (n2 > this.getRowCount()) {
            return false;
        }
        return this.getImmutableCellAt(n, n2).isValid();
    }

    public final MutableCell<D> getCellAt(int n, int n2) {
        return this.getMutableRow(n2).getMutableCellAt(n);
    }

    public final MutableCell<D> getCellAt(String string) {
        return this.getCellAt(this.resolveHint(string));
    }

    final MutableCell<D> getCellAt(Point point) {
        return this.getCellAt(point.x, point.y);
    }

    public final void setValueAt(Object object, int n, int n2) {
        if (object == null) {
            object = "";
        }
        if (!object.equals(this.getValueAt(n, n2))) {
            this.getCellAt(n, n2).setValue(object);
        }
    }

    public final Cell<D> getImmutableCellAt(int n, int n2) {
        return this.getRow(n2).getCellAt(n);
    }

    public final Cell<D> getImmutableCellAt(String string) {
        Point point = this.resolveHint(string);
        return this.getImmutableCellAt(point.x, point.y);
    }

    public final Point getCoverOrigin(int n, int n2) {
        Cell<D> cell = this.getImmutableCellAt(n, n2);
        if (cell.coversOtherCells()) {
            return new Point(n, n2);
        }
        if (!cell.isCovered()) {
            return null;
        }
        Row<D> row = this.getRow(n2);
        Cell<D> cell2 = cell;
        int n3 = n;
        while (n3 > 0 && cell2.isCovered()) {
            cell2 = row.getCellAt(--n3);
        }
        if (cell2.coversOtherCells()) {
            return new Point(n3, n2);
        }
        if (!cell2.isCovered()) {
            cell2 = row.getCellAt(++n3);
        }
        assert (cell2.isCovered());
        int n4 = n2;
        while (!cell2.coversOtherCells()) {
            cell2 = this.getImmutableCellAt(n3, --n4);
        }
        return new Point(n3, n4);
    }

    public final Object getValueAt(int n, int n2) {
        return this.getImmutableCellAt(n, n2).getValue();
    }

    public final String getStyleNameAt(int n, int n2) {
        String string = this.getImmutableCellAt(n, n2).getStyleAttr();
        if (string != null) {
            return string;
        }
        string = this.getRow(n2).getElement().getAttributeValue("default-cell-style-name", this.getTABLE());
        if (string != null) {
            return string;
        }
        return this.getColumn(n).getElement().getAttributeValue("default-cell-style-name", this.getTABLE());
    }

    public final CellStyle getStyleAt(int n, int n2) {
        return (CellStyle)this.getCellStyleDesc().findStyleForNode(this.getImmutableCellAt(n, n2), this.getStyleNameAt(n, n2));
    }

    protected StyleStyleDesc<CellStyle> getCellStyleDesc() {
        return Style.getStyleStyleDesc(CellStyle.class, ((ODDocument)this.getODDocument()).getVersion());
    }

    public final CellStyle getDefaultCellStyle() {
        return this.getCellStyleDesc().findDefaultStyle(((ODDocument)this.getODDocument()).getPackage());
    }

    public final List<Tuple2<Integer, Integer>> getStyleReferences(String string) {
        int n;
        ArrayList<Tuple2<Integer, Integer>> arrayList = new ArrayList<Tuple2<Integer, Integer>>();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        int n2 = this.getColumnCount();
        for (n = 0; n < n2; ++n) {
            if (!string.equals(this.getColumn(n).getElement().getAttributeValue("default-cell-style-name", this.getTABLE()))) continue;
            hashSet.add(n);
        }
        n = this.getRowCount();
        for (int i = 0; i < n; ++i) {
            Row<D> row = this.getRow(i);
            String string2 = row.getElement().getAttributeValue("default-cell-style-name", this.getTABLE());
            for (int j = 0; j < n2; ++j) {
                String string3 = row.getCellAt(j).getStyleAttr();
                boolean bl = string3 != null ? string.equals(string3) : (string2 != null ? string.equals(string2) : hashSet.contains(j));
                if (!bl) continue;
                arrayList.add(Tuple2.create(j, i));
            }
        }
        return arrayList;
    }

    protected final StyleStyleDesc<ColumnStyle> getColumnStyleDesc() {
        return Style.getStyleStyleDesc(ColumnStyle.class, XMLVersion.getVersion(this.getElement()));
    }

    protected final StyleStyleDesc<RowStyle> getRowStyleDesc() {
        return Style.getStyleStyleDesc(RowStyle.class, XMLVersion.getVersion(this.getElement()));
    }

    public final Object getValueAt(String string) {
        return this.getImmutableCellAt(string).getValue();
    }

    final Row<D> getRow(int n) {
        return this.rows.get(n);
    }

    final Row<D> getMutableRow(int n) {
        Row<D> row = this.getRow(n);
        if (row.getRepeated() > 1) {
            RepeatedBreaker.getRowBreaker().breakRepeated(this, this.rows, n);
            return this.getRow(n);
        }
        return row;
    }

    public final Column<D> getColumn(int n) {
        return this.cols.get(n);
    }

    public final int getRowCount() {
        return this.rows.size();
    }

    public final TableGroup getRowGroup() {
        return this.rowGroup;
    }

    public final TableGroup getRowGroupAt(int n) {
        return this.getRowGroup().getDescendentOrSelfContaining(n);
    }

    public final int getHeaderRowCount() {
        return this.getRowGroup().getFollowingHeaderCount();
    }

    public final int getColumnCount() {
        return this.cols.size();
    }

    public final TableGroup getColumnGroup() {
        return this.columnGroup;
    }

    public final TableGroup getColumnGroupAt(int n) {
        return this.getColumnGroup().getDescendentOrSelfContaining(n);
    }

    public final int getHeaderColumnCount() {
        return this.getColumnGroup().getFollowingHeaderCount();
    }

    public final void setColumnCount(int n) {
        this.setColumnCount(n, -1, false);
    }

    public final void ensureColumnCount(int n) {
        if (n > this.getColumnCount()) {
            this.setColumnCount(n);
        }
    }

    public final void setColumnCount(int n, int n2, boolean bl) {
        int n3 = n - this.getColumnCount();
        if (n3 < 0) {
            this.removeColumn(n, this.getColumnCount(), bl);
        } else if (n3 > 0) {
            Row<D> row;
            int n4 = this.getColumnCount() == 0 ? this.getElement().getContentSize() - 1 : this.getElement().getContent().indexOf(this.getColumn(this.getColumnCount() - 1).getElement());
            Element element = n2 < 0 ? Column.createEmpty(((ODDocument)this.getODDocument()).getVersion(), this.createDefaultColStyle()) : this.getColumn(n2).getElement();
            StyleStyleDesc<ColumnStyle> styleStyleDesc = this.getColumnStyleDesc();
            for (int i = 0; i < n3; ++i) {
                Element element2 = (Element)element.clone();
                this.getElement().addContent(n4 + 1 + i, element2);
                this.cols.add(new Column(this, element2, styleStyleDesc));
            }
            this.updateWidth(bl);
            StyleStyleDesc<CellStyle> styleStyleDesc2 = this.getCellStyleDesc();
            int n5 = this.getRowCount();
            for (int i = 0; i < n5; i += row.getRepeated()) {
                row = this.getRow(i);
                row.columnCountChanged(styleStyleDesc2);
            }
        }
    }

    public final void removeColumn(int n, boolean bl) {
        this.removeColumn(n, n + 1, bl);
    }

    public final void removeColumn(int n, int n2, boolean bl) {
        int n3;
        Row<D> row;
        int n4 = this.getRowCount();
        for (n3 = 0; n3 < n4; n3 += row.getRepeated()) {
            row = this.getRow(n3);
            row.checkRemove(n, n2);
        }
        this.remove(Axis.COLUMN, n, n2 - 1);
        this.updateWidth(bl);
        for (n3 = 0; n3 < n4; n3 += row.getRepeated()) {
            row = this.getRow(n3);
            row.removeCells(n, n2);
        }
    }

    private void updateWidth(boolean bl) {
        Float f = this.getWidth();
        float f2 = 0.0f;
        Column<D> column = null;
        for (Column<D> object2 : this.cols) {
            Float f3 = object2.getWidth();
            if (f3 != null) {
                assert (f3.floatValue() >= 0.0f);
                f2 += f3.floatValue();
                continue;
            }
            f2 = -1.0f;
            column = object2;
            break;
        }
        if (bl && f != null) {
            if (column != null) {
                throw new IllegalStateException("Cannot keep width since a column has no width : " + column);
            }
            float f3 = f.floatValue() / f2;
            HashSet hashSet = new HashSet();
            for (Column<D> column2 : this.cols) {
                hashSet.add(column2.getStyle());
            }
            for (ColumnStyle columnStyle : hashSet) {
                columnStyle.setWidth(columnStyle.getWidth().floatValue() * f3);
            }
        } else {
            TableStyle tableStyle = (TableStyle)this.getStyle();
            if (tableStyle != null) {
                if (column != null) {
                    throw new IllegalStateException("Cannot update table width since a column has no width : " + column);
                }
                tableStyle.setWidth(f2);
            }
            for (Column<D> column3 : this.cols) {
                ColumnStyle columnStyle = (ColumnStyle)column3.getStyle();
                if (columnStyle == null) continue;
                columnStyle.rmRelWidth();
            }
        }
    }

    public final Float getWidth() {
        TableStyle tableStyle = (TableStyle)this.getStyle();
        return tableStyle == null ? null : tableStyle.getWidth();
    }

    private final ColumnStyle createDefaultColStyle() {
        ColumnStyle columnStyle = (ColumnStyle)ColumnStyle.DESC.createAutoStyle(((ODDocument)this.getODDocument()).getPackage(), "defaultCol");
        columnStyle.setWidth(20.0f);
        return columnStyle;
    }

    private final void setCount(Axis axis, int n) {
        this.remove(axis, n, -1);
    }

    private final void remove(Axis axis, int n, int n2) {
        assert (axis == Axis.COLUMN || n2 < 0) : "Row index will be wrong";
        ArrayList<TableCalcNode> arrayList = axis == Axis.COLUMN ? this.cols : this.rows;
        int n3 = CollectionUtils.getValidIndex(arrayList, n2);
        int n4 = n3 - n + 1;
        int n5 = 0;
        while (n5 < n4) {
            int n6 = n3 - n5;
            TableCalcNode tableCalcNode = (TableCalcNode)arrayList.get(n6);
            if (tableCalcNode instanceof Row) {
                Row row = (Row)tableCalcNode;
                int n7 = n6 - Math.max(n, row.getY()) + 1;
                assert (n7 > 0);
                int n8 = row.getRepeated() - n7;
                if (n8 == 0) {
                    tableCalcNode.getElement().detach();
                } else {
                    row.setRepeated(n8);
                }
                n5 += n7;
                continue;
            }
            tableCalcNode.getElement().detach();
            ++n5;
        }
        arrayList.subList(n, n3 + 1).clear();
    }

    public final void ensureRowCount(int n) {
        if (n > this.getRowCount()) {
            this.setRowCount(n);
        }
    }

    public final void setRowCount(int n) {
        this.setRowCount(n, -1);
    }

    public final void setRowCount(int n, int n2) {
        int n3 = n - this.getRowCount();
        if (n3 < 0) {
            this.setCount(Axis.ROW, n);
        } else if (n3 > 0) {
            Element element;
            if (n2 < 0) {
                element = Row.createEmpty(((ODDocument)this.getODDocument()).getVersion());
                element.addContent(Cell.createEmpty(((ODDocument)this.getODDocument()).getVersion(), this.getColumnCount()));
            } else {
                element = (Element)this.getRow(n2).getElement().clone();
            }
            Axis.ROW.setRepeated(element, n3);
            this.getElement().addContent(element);
            this.addRow(element, this.getRowStyleDesc(), this.getCellStyleDesc());
        }
    }

    public final SheetTableModel<D> getTableModel(int n, int n2) {
        return new SheetTableModel(this, n2, n);
    }

    public final SheetTableModel<D> getTableModel(int n, int n2, int n3, int n4) {
        return new SheetTableModel(this, n2, n, n4, n3);
    }

    public final SheetTableModel.MutableTableModel<D> getMutableTableModel(int n, int n2) {
        return new SheetTableModel.MutableTableModel(this, n2, n);
    }

    public final SheetTableModel.MutableTableModel<D> getMutableTableModel(Point point, Point point2) {
        return new SheetTableModel.MutableTableModel(this, point.y, point.x, point2.y + 1, point2.x + 1);
    }

    public final void merge(TableModel tableModel, int n, int n2) {
        this.merge(tableModel, n, n2, false);
    }

    public final void merge(TableModel tableModel, int n, int n2, boolean bl) {
        int n3;
        int n4 = bl ? 1 : 0;
        this.ensureColumnCount(n + tableModel.getColumnCount());
        this.ensureRowCount(n2 + tableModel.getRowCount() + n4);
        SheetTableModel.MutableTableModel<D> mutableTableModel = this.getMutableTableModel(n, n2);
        if (bl) {
            for (n3 = 0; n3 < tableModel.getColumnCount(); ++n3) {
                mutableTableModel.setValueAt(tableModel.getColumnName(n3), 0, n3);
            }
        }
        for (n3 = 0; n3 < tableModel.getRowCount(); ++n3) {
            for (int i = 0; i < tableModel.getColumnCount(); ++i) {
                Object object = tableModel.getValueAt(n3, i);
                mutableTableModel.setValueAt(object, n3 + n4, i);
            }
        }
    }

    public final Range getUsedRange() {
        return this.getUsedRange(false);
    }

    public final Range getUsedRange(boolean bl) {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = this.getColumnCount();
        int n6 = this.getRowCount();
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n6; ++j) {
                if (this.isCellBlank(i, j, bl)) continue;
                if (n < 0 || i < n) {
                    n = i;
                }
                if (n2 < 0 || j < n2) {
                    n2 = j;
                }
                if (n3 < 0 || i > n3) {
                    n3 = i;
                }
                if (n4 >= 0 && j <= n4) continue;
                n4 = j;
            }
        }
        return n < 0 ? null : new Range(this.getName(), new Point(n, n2), new Point(n3, n4));
    }

    protected final boolean isCellBlank(int n, int n2, boolean bl) {
        if (!this.getImmutableCellAt(n, n2).isEmpty()) {
            return false;
        }
        if (bl) {
            CellStyle cellStyle = this.getStyleAt(n, n2);
            return cellStyle == null || cellStyle.getBackgroundColor() == null && cellStyle.getTableCellProperties().getBorders().isEmpty();
        }
        return true;
    }

    public final Range getCurrentRegion(String string) {
        return this.getCurrentRegion(string, false);
    }

    public final Range getCurrentRegion(String string, boolean bl) {
        Point point = this.resolveHint(string);
        return this.getCurrentRegion(point.x, point.y, bl);
    }

    public final Range getCurrentRegion(int n, int n2) {
        return this.getCurrentRegion(n, n2, false);
    }

    public final Range getCurrentRegion(int n, int n2, boolean bl) {
        return new RegionExplorer(n, n2, bl).getCurrentRegion();
    }

    static final Point resolve(String string) {
        Matcher matcher = SpreadSheet.minCellPattern.matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        return Table.resolve(matcher.group(1), matcher.group(2));
    }

    static final Point resolve(String string, String string2) {
        return new Point(Table.toInt(string), Integer.parseInt(string2) - 1);
    }

    static final int toInt(String string) {
        if (string.length() < 1) {
            throw new IllegalArgumentException("x cannot be empty");
        }
        string = string.toUpperCase();
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            n = n * 26 + (string.charAt(i) - 65 + 1);
        }
        return n - 1;
    }

    static final String toStr(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("negative column : " + n);
        }
        ++n;
        StringBuilder stringBuilder = new StringBuilder(4);
        while (n > 0) {
            stringBuilder.append((char)(65 + (n - 1) % 26));
            n = (n - 1) / 26;
        }
        return stringBuilder.reverse().toString();
    }

    static final String getAddress(Point point) {
        if (point.x < 0 || point.y < 0) {
            throw new IllegalArgumentException("negative coordinates : " + point);
        }
        return Table.toStr(point.x) + (point.y + 1);
    }

    private class RegionExplorer {
        private final boolean checkStyle;
        private final int rowCount;
        private final int colCount;
        protected int minX;
        protected int minY;
        protected int maxX;
        protected int maxY;

        public RegionExplorer(int n, int n2, boolean bl) {
            this.rowCount = Table.this.getRowCount();
            this.colCount = Table.this.getColumnCount();
            this.minX = this.maxX = n;
            this.minY = this.maxY = n2;
            this.checkStyle = bl;
        }

        public boolean canXDecrement() {
            return this.minX > 0;
        }

        public boolean canYDecrement() {
            return this.minY > 0;
        }

        public boolean canXIncrement() {
            return this.maxX < this.colCount - 1;
        }

        public boolean canYIncrement() {
            return this.maxY < this.rowCount - 1;
        }

        private boolean checkRow(boolean bl) {
            if (bl && this.canYDecrement() || !bl && this.canYIncrement()) {
                int n = bl ? this.minY - 1 : this.maxY + 1;
                int n2 = this.canXDecrement() ? this.minX - 1 : this.minX;
                int n3 = this.canXIncrement() ? this.maxX + 1 : this.maxX;
                for (int i = n2; i <= n3; ++i) {
                    if (Table.this.isCellBlank(i, n, this.checkStyle)) continue;
                    if (bl) {
                        this.minY = n;
                    } else {
                        this.maxY = n;
                    }
                    if (i < this.minX) {
                        this.minX = i;
                    }
                    if (i > this.maxX) {
                        this.maxX = i;
                    }
                    return true;
                }
            }
            return false;
        }

        private boolean checkCol(boolean bl) {
            if (bl && this.canXDecrement() || !bl && this.canXIncrement()) {
                int n = bl ? this.minX - 1 : this.maxX + 1;
                for (int i = this.minY; i <= this.maxY; ++i) {
                    if (Table.this.isCellBlank(n, i, this.checkStyle)) continue;
                    if (bl) {
                        this.minX = n;
                    } else {
                        this.maxX = n;
                    }
                    return true;
                }
            }
            return false;
        }

        private final boolean checkFrame() {
            return this.checkRow(true) || this.checkRow(false) || this.checkCol(true) || this.checkCol(false);
        }

        public final Range getCurrentRegion() {
            while (this.checkFrame()) {
            }
            return new Range(Table.this.getName(), new Point(this.minX, this.minY), new Point(this.maxX, this.maxY));
        }
    }
}

