/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.spreadsheet;

import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.table.TableModel;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;
import org.jopendocument.dom.ContentType;
import org.jopendocument.dom.ContentTypeVersioned;
import org.jopendocument.dom.ODDocument;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.OOUtils;
import org.jopendocument.dom.XMLFormatVersion;
import org.jopendocument.dom.spreadsheet.Cell;
import org.jopendocument.dom.spreadsheet.Range;
import org.jopendocument.dom.spreadsheet.Sheet;
import org.jopendocument.dom.spreadsheet.SheetTableModel;
import org.jopendocument.dom.spreadsheet.Table;
import org.jopendocument.util.Tuple2;

public class SpreadSheet
extends ODDocument {
    private final Map<Element, Sheet> sheets = new HashMap<Element, Sheet>();
    private static final String minCell = "\\$?([A-Z]+)\\$?([0-9]+)";
    static final Pattern cellPattern = Pattern.compile("(\\$?([^\\. ']+|'([^']|'')+'))?\\.(\\$?([A-Z]+)\\$?([0-9]+))");
    static final Pattern minCellPattern = Pattern.compile("\\$?([A-Z]+)\\$?([0-9]+)");
    static final Pattern cellRangePattern = Pattern.compile("(\\$?([^\\. ']+|'([^']|'')+'))?\\.(\\$?[A-Z]+\\$?[0-9]+)(:(\\$?([^\\. ']+|'([^']|'')+'))?\\.(\\$?[A-Z]+\\$?[0-9]+))?");
    static final Pattern tableNameQuoteQuotePattern = Pattern.compile("''", 16);
    static final Pattern tableNameQuotePattern = Pattern.compile("'", 16);
    static final Pattern tableNameQuoteNeededPattern = Pattern.compile("[ \t.']");

    public static SpreadSheet createFromFile(File file) throws IOException {
        return new ODPackage(file).getSpreadSheet();
    }

    public static SpreadSheet get(ODPackage oDPackage) {
        return oDPackage.hasODDocument() ? oDPackage.getSpreadSheet() : new SpreadSheet(oDPackage);
    }

    public static SpreadSheet createEmpty(TableModel tableModel) throws IOException {
        return SpreadSheet.createEmpty(tableModel, XMLFormatVersion.getDefault());
    }

    public static SpreadSheet createEmpty(TableModel tableModel, XMLFormatVersion xMLFormatVersion) throws IOException {
        ContentTypeVersioned contentTypeVersioned = ContentType.SPREADSHEET.getVersioned(xMLFormatVersion.getXMLVersion());
        SpreadSheet spreadSheet = contentTypeVersioned.createPackage(xMLFormatVersion).getSpreadSheet();
        spreadSheet.getBody().addContent(Sheet.createEmpty(xMLFormatVersion.getXMLVersion()));
        spreadSheet.getSheet(0).merge(tableModel, 0, 0, true);
        return spreadSheet;
    }

    public static File export(TableModel tableModel, File file, XMLFormatVersion xMLFormatVersion) throws IOException {
        return SpreadSheet.createEmpty(tableModel, xMLFormatVersion).saveAs(file);
    }

    private SpreadSheet(ODPackage oDPackage) {
        super(oDPackage);
    }

    protected static final String parseSheetName(String string) {
        String string2;
        if (string == null) {
            return null;
        }
        String string3 = string2 = string.charAt(0) == '$' ? string.substring(1) : string;
        if (string2.charAt(0) == '\'') {
            if (string2.charAt(string2.length() - 1) != '\'') {
                throw new IllegalArgumentException("Missing closing quote");
            }
            string2 = tableNameQuoteQuotePattern.matcher(string2.substring(1, string2.length() - 1)).replaceAll(tableNameQuotePattern.pattern());
        }
        return string2;
    }

    protected static final String formatSheetName(String string) {
        if (string == null) {
            return null;
        }
        if (tableNameQuoteNeededPattern.matcher(string).find()) {
            return "'" + tableNameQuotePattern.matcher(string).replaceAll(tableNameQuoteQuotePattern.pattern()) + "'";
        }
        return string;
    }

    public final SheetTableModel.MutableTableModel<SpreadSheet> getTableModel(String string) {
        Element element;
        Object object;
        try {
            object = this.getXPath("./table:named-expressions/table:named-range[@table:name='" + string + "']");
            element = (Element)((XPath)object).selectSingleNode(this.getBody());
        }
        catch (JDOMException jDOMException) {
            throw new IllegalStateException(jDOMException);
        }
        if (element == null) {
            return null;
        }
        object = element.getAttributeValue("cell-range-address", this.getVersion().getTABLE());
        Range range = Range.parse((String)object);
        if (range.spanSheets()) {
            throw new UnsupportedOperationException("different sheet names: " + range.getStartSheet() + " != " + range.getEndSheet());
        }
        Sheet sheet = this.getSheet(range.getStartSheet(), true);
        return sheet.getMutableTableModel(range.getStartPoint(), range.getEndPoint());
    }

    public final Cell<SpreadSheet> getCellAt(String string) {
        Tuple2<Sheet, Point> tuple2 = this.resolve(string);
        return tuple2.get0().getCellAt(tuple2.get1());
    }

    public final Tuple2<Sheet, Point> resolve(String string) {
        Matcher matcher = cellPattern.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(string + " is not a valid cell address: " + matcher.pattern().pattern());
        }
        String string2 = SpreadSheet.parseSheetName(matcher.group(1));
        if (string2 == null) {
            throw new IllegalArgumentException("no sheet specified: " + string);
        }
        return Tuple2.create(this.getSheet(string2, true), Sheet.resolve(matcher.group(5), matcher.group(6)));
    }

    public XPath getXPath(String string) throws JDOMException {
        return OOUtils.getXPath(string, this.getVersion());
    }

    private final List<Element> getTables() {
        return this.getBody().getChildren("table", this.getVersion().getTABLE());
    }

    public int getSheetCount() {
        return this.getTables().size();
    }

    public Sheet getSheet(int n) {
        return this.getSheet(this.getTables().get(n));
    }

    public Sheet getSheet(String string) {
        return this.getSheet(string, false);
    }

    public Sheet getSheet(String string, boolean bl) throws NoSuchElementException {
        for (Element element : this.getTables()) {
            if (!string.equals(Table.getName(element))) continue;
            return this.getSheet(element);
        }
        if (bl) {
            throw new NoSuchElementException("no such sheet: " + string);
        }
        return null;
    }

    private final Sheet getSheet(Element element) {
        Sheet sheet = this.sheets.get(element);
        if (sheet == null) {
            sheet = new Sheet(this, element);
            this.sheets.put(element, sheet);
        }
        return sheet;
    }

    void invalidate(Element element) {
        this.sheets.remove(element);
    }

    public final Sheet addSheet(int n, String string) {
        if (string == null) {
            throw new NullPointerException("null name");
        }
        Element element = Table.createEmpty(this.getVersion());
        return this.addSheet(n, element, string);
    }

    final Sheet addSheet(int n, Element element, String string) {
        this.getBody().addContent(this.getContentIndex(n), element);
        Sheet sheet = this.getSheet(element);
        if (string != null) {
            sheet.setName(string);
        }
        assert (sheet.getName() != null);
        return sheet;
    }

    private final int getContentIndex(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("Negative index: " + n);
        }
        ArrayList<Element> arrayList = new ArrayList<Element>(this.getTables());
        if (n > arrayList.size()) {
            throw new IndexOutOfBoundsException("index (" + n + ") > count (" + arrayList.size() + ")");
        }
        int n2 = n == arrayList.size() ? this.getBody().indexOf((Content)arrayList.get(n - 1)) + 1 : this.getBody().indexOf((Content)arrayList.get(n));
        return n2;
    }

    public final Sheet addSheet(String string) {
        return this.addSheet(this.getSheetCount(), string);
    }

    void move(Sheet sheet, int n) {
        Element element = sheet.getElement().getParentElement();
        sheet.getElement().detach();
        element.addContent(this.getContentIndex(n), sheet.getElement());
    }
}

