/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.spreadsheet;

import java.util.List;
import org.jdom.Element;
import org.jopendocument.dom.ODDocument;
import org.jopendocument.dom.ODNode;
import org.jopendocument.dom.StyleDesc;
import org.jopendocument.dom.spreadsheet.Axis;
import org.jopendocument.dom.spreadsheet.Cell;
import org.jopendocument.dom.spreadsheet.CellStyle;
import org.jopendocument.dom.spreadsheet.MutableCell;
import org.jopendocument.dom.spreadsheet.Row;
import org.jopendocument.dom.spreadsheet.Table;

abstract class RepeatedBreaker<P, C extends ODNode> {
    private static final RepeatedBreaker CELL_BREAKER = new RepeatedBreaker<Row<?>, Cell<?>>("number-columns-repeated"){

        @Override
        Cell<?> create(Element element, Row<?> row, int n, boolean bl) {
            return this.createD(element, row, n, bl);
        }

        <D extends ODDocument> Cell<D> createD(Element element, Row<D> row, int n, boolean bl) {
            return bl ? new MutableCell<D>(row, element, (StyleDesc<CellStyle>)row.getSheet().getCellStyleDesc()) : new Cell<D>(row, element, (StyleDesc<CellStyle>)row.getSheet().getCellStyleDesc());
        }
    };
    private static final RepeatedBreaker ROW_BREAKER = new RepeatedBreaker<Table<?>, Row<?>>(Axis.ROW.getRepeatedAttrName()){

        @Override
        Row<?> create(Element element, Table<?> table, int n, boolean bl) {
            return this.createD(element, table, n, bl);
        }

        <D extends ODDocument> Row<D> createD(Element element, Table<D> table, int n, boolean bl) {
            return new Row<D>(table, element, n, table.getRowStyleDesc(), table.getCellStyleDesc());
        }
    };
    private final String attrName;

    static final <D extends ODDocument> RepeatedBreaker<Row<D>, Cell<D>> getCellBreaker() {
        return CELL_BREAKER;
    }

    static final <D extends ODDocument> RepeatedBreaker<Table<D>, Row<D>> getRowBreaker() {
        return ROW_BREAKER;
    }

    public RepeatedBreaker(String string) {
        this.attrName = string;
    }

    abstract C create(Element var1, P var2, int var3, boolean var4);

    public final void breakRepeated(P p, List<C> list, int n) {
        ODNode oDNode = (ODNode)list.get(n);
        Element element = oDNode.getElement();
        String string = element.getAttributeValue(this.attrName, element.getNamespace());
        if (string != null) {
            int n2 = Integer.parseInt(string);
            int n3 = list.indexOf(oDNode);
            int n4 = n3 + n2 - 1;
            int n5 = n - n3;
            int n6 = n4 - n;
            this.breakRepeated(p, list, element, n3, n5, true);
            element.removeAttribute(this.attrName, element.getNamespace());
            this.breakRepeated(p, list, element, n + 1, n6, false);
        }
        list.set(n, this.create(element, p, n, true));
    }

    private final void breakRepeated(P p, List<C> list, Element element, int n, int n2, boolean bl) {
        if (n2 > 0) {
            Element element2 = (Element)element.clone();
            element.getParentElement().addContent(element.getParent().indexOf(element) + (bl ? 0 : 1), element2);
            element2.setAttribute(this.attrName, n2 + "", element.getNamespace());
            C c = this.create(element2, p, n, false);
            for (int i = 0; i < n2; ++i) {
                list.set(n + i, c);
            }
        }
    }
}

