/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.spreadsheet;

import java.math.BigDecimal;
import org.jdom.Element;
import org.jopendocument.dom.LengthUnit;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.StyleProperties;
import org.jopendocument.dom.StyleStyle;
import org.jopendocument.dom.StyleStyleDesc;
import org.jopendocument.dom.XMLVersion;
import org.jopendocument.dom.spreadsheet.TableStyle;

public class ColumnStyle
extends StyleStyle {
    public static final StyleStyleDesc<ColumnStyle> DESC = new StyleStyleDesc<ColumnStyle>(ColumnStyle.class, XMLVersion.OD, "table-column", "co", "table"){

        @Override
        public ColumnStyle create(ODPackage oDPackage, Element element) {
            return new ColumnStyle(oDPackage, element);
        }
    };
    private StyleTableColumnProperties colProps;

    public ColumnStyle(ODPackage oDPackage, Element element) {
        super(oDPackage, element);
    }

    public final StyleTableColumnProperties getTableColumnProperties() {
        if (this.colProps == null) {
            this.colProps = new StyleTableColumnProperties(this);
        }
        return this.colProps;
    }

    public final Float getWidth() {
        BigDecimal bigDecimal = this.getTableColumnProperties().getWidth(TableStyle.DEFAULT_UNIT);
        return bigDecimal == null ? null : Float.valueOf(bigDecimal.floatValue());
    }

    void setWidth(float f) {
        this.getFormattingProperties().setAttribute("column-width", f + TableStyle.DEFAULT_UNIT.getSymbol(), this.getSTYLE());
        this.rmRelWidth();
    }

    void rmRelWidth() {
        this.getFormattingProperties().removeAttribute("rel-column-width", this.getSTYLE());
    }

    public static class StyleTableColumnProperties
    extends StyleProperties {
        public StyleTableColumnProperties(StyleStyle styleStyle) {
            super(styleStyle, styleStyle.getFamily());
        }

        public final BigDecimal getWidth(LengthUnit lengthUnit) {
            return LengthUnit.parseLength(this.getAttributeValue("column-width", this.getNS("style")), lengthUnit);
        }

        public final String getBreakBefore() {
            return this.getAttributeValue("break-before", this.getNS("fo"));
        }

        public final String getBreakAfter() {
            return this.getAttributeValue("break-after", this.getNS("fo"));
        }
    }
}

