/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.spreadsheet;

import java.awt.Color;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jopendocument.dom.Log;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.ODValueType;
import org.jopendocument.dom.Style;
import org.jopendocument.dom.StyleStyle;
import org.jopendocument.dom.StyleStyleDesc;
import org.jopendocument.dom.StyledNode;
import org.jopendocument.dom.XMLVersion;
import org.jopendocument.dom.spreadsheet.Cell;
import org.jopendocument.dom.style.RelationalOperator;
import org.jopendocument.dom.style.SideStyleProperties;
import org.jopendocument.dom.style.data.BooleanStyle;
import org.jopendocument.dom.style.data.DataStyle;
import org.jopendocument.dom.style.data.NumberStyle;
import org.jopendocument.dom.text.ParagraphStyle;
import org.jopendocument.dom.text.TextStyle;
import org.jopendocument.util.CompareUtils;
import org.jopendocument.util.JDOMUtils;
import org.jopendocument.util.Tuple3;

public class CellStyle
extends StyleStyle {
    private static final Pattern numberPatrn = Pattern.compile("-?\\d+(?:\\.\\d+)?");
    private static final Pattern escapedQuotePatrn = Pattern.compile("\"\"", 16);
    private static final Pattern stringPatrn = Pattern.compile("\"(?:[^\\p{Cntrl}\"]|\\p{Space}|" + escapedQuotePatrn.pattern() + ")*\"");
    private static final String valuePatrn = "(" + numberPatrn.pattern() + "|" + stringPatrn.pattern() + ")";
    private static final Pattern cellContentPatrn = Pattern.compile("cell-content\\(\\) *(" + RelationalOperator.OR_PATTERN + ") *" + valuePatrn + "");
    private static final Pattern cellContentBetweenPatrn = Pattern.compile("cell-content-is(?:-not)?-between\\(" + valuePatrn + ", *" + valuePatrn + "\\)");
    public static final StyleStyleDesc<CellStyle> DESC = new StyleStyleDesc<CellStyle>(CellStyle.class, XMLVersion.OD, "table-cell", "ce", "table", Arrays.asList("table:body", "table:covered-table-cell", "table:even-rows", "table:first-column", "table:first-row", "table:last-column", "table:last-row", "table:odd-columns", "table:odd-rows", "table:table-cell")){
        {
            this.getMultiRefElementsMap().putAll("table:default-cell-style-name", (String[])new String[]{"table:table-column", "table:table-row"});
        }

        @Override
        public CellStyle create(ODPackage oDPackage, Element element) {
            return new CellStyle(oDPackage, element);
        }

        @Override
        protected boolean supportConditions() {
            return true;
        }

        @Override
        protected Element evaluateConditions(StyledNode<CellStyle, ?> styledNode, List<Element> list) {
            Cell cell = (Cell)styledNode;
            Object object = cell.getValue();
            for (Element element : list) {
                String string = element.getAttributeValue("condition", this.getVersion().getSTYLE()).trim();
                Matcher matcher = cellContentPatrn.matcher(string);
                if (matcher.matches()) {
                    if (!RelationalOperator.getInstance(matcher.group(1)).compare(object, CellStyle.parse(matcher.group(2)))) continue;
                    return element;
                }
                matcher = cellContentBetweenPatrn.matcher(string);
                if (matcher.matches()) {
                    boolean bl = string.startsWith("cell-content-is-between");
                    assert (bl ^ string.startsWith("cell-content-is-not-between"));
                    Object object2 = CellStyle.parse(matcher.group(1));
                    Object object3 = CellStyle.parse(matcher.group(2));
                    boolean bl2 = CompareUtils.compare(object, object2) >= 0 && CompareUtils.compare(object, object3) <= 0;
                    if (bl2 != bl) continue;
                    return element;
                }
                Log.get().fine("Ignoring " + JDOMUtils.output(element));
            }
            return null;
        }
    };
    private static final Pattern conditionPatrn = Pattern.compile("value\\(\\) *(" + RelationalOperator.OR_PATTERN + ") *(true|false|" + numberPatrn.pattern() + ")");
    private StyleTableCellProperties cellProps;
    private TextStyle.StyleTextProperties textProps;
    private ParagraphStyle.StyleParagraphProperties pProps;

    private static final Object convertForCondition(Object object, DataStyle dataStyle) {
        Serializable serializable = dataStyle instanceof BooleanStyle ? (Serializable)BooleanStyle.toBoolean(object) : (Serializable)NumberStyle.toNumber(object, dataStyle.getEpoch());
        return serializable;
    }

    public CellStyle(ODPackage oDPackage, Element element) {
        super(oDPackage, element);
    }

    private final DataStyle getDataStyle(Attribute attribute) {
        return (DataStyle)Style.getReferencedStyle(this.getPackage(), attribute);
    }

    final Tuple3<DataStyle, ODValueType, Object> getDataStyle(Object object, ODValueType oDValueType, boolean bl) {
        DataStyle dataStyle = this.getDataStyle(this.getElement().getAttribute("data-style-name", this.getSTYLE()));
        ODValueType oDValueType2 = oDValueType;
        Object object2 = object;
        if (dataStyle != null && oDValueType != null) {
            Object object3;
            Object object4;
            if (!bl && (object4 = dataStyle.convert(object)) != null) {
                object2 = object4;
                oDValueType2 = dataStyle.getDataType();
            }
            if ((object4 = dataStyle.getElement().getChildren("map", this.getSTYLE())).size() > 0 && (object3 = CellStyle.convertForCondition(object2, dataStyle)) != null) {
                Iterator iterator = object4.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    Element element = (Element)e;
                    Matcher matcher = conditionPatrn.matcher(element.getAttributeValue("condition", this.getSTYLE()).trim());
                    if (!matcher.matches()) {
                        throw new IllegalStateException("Cannot parse " + JDOMUtils.output(element));
                    }
                    if (!RelationalOperator.getInstance(matcher.group(1)).compare(object3, CellStyle.parse(matcher.group(2)))) continue;
                    dataStyle = this.getDataStyle(element.getAttribute("apply-style-name", this.getSTYLE()));
                    break;
                }
            }
        }
        assert (oDValueType == null == (oDValueType2 == null)) : "don't change type to null";
        assert (!bl || oDValueType2 == oDValueType && object2 == object) : "Requested to only cast, but different object";
        return dataStyle == null ? null : Tuple3.create(dataStyle, oDValueType2, object2);
    }

    private static Object parse(String string) {
        if (string.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (string.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        if (string.charAt(0) == '\"') {
            return escapedQuotePatrn.matcher(string.substring(1, string.length() - 1)).replaceAll("\"");
        }
        return new BigDecimal(string);
    }

    public final Color getBackgroundColor() {
        return this.getTableCellProperties().getBackgroundColor();
    }

    public final StyleTableCellProperties getTableCellProperties() {
        if (this.cellProps == null) {
            this.cellProps = new StyleTableCellProperties(this);
        }
        return this.cellProps;
    }

    public final TextStyle.StyleTextProperties getTextProperties() {
        if (this.textProps == null) {
            this.textProps = new TextStyle.StyleTextProperties(this);
        }
        return this.textProps;
    }

    public final ParagraphStyle.StyleParagraphProperties getParagraphProperties() {
        if (this.pProps == null) {
            this.pProps = new ParagraphStyle.StyleParagraphProperties(this);
        }
        return this.pProps;
    }

    public static class StyleTableCellProperties
    extends SideStyleProperties {
        public StyleTableCellProperties(StyleStyle styleStyle) {
            super(styleStyle, DESC.getFamily());
        }

        public final int getRotationAngle() {
            String string = this.getAttributeValue("rotation-angle", this.getElement().getNamespace("style"));
            return StyleTableCellProperties.parseInt(string, 0);
        }

        public final boolean isContentPrinted() {
            return StyleTableCellProperties.parseBoolean(this.getAttributeValue("print-content", this.getElement().getNamespace("style")), true);
        }

        public final boolean isContentRepeated() {
            return StyleTableCellProperties.parseBoolean(this.getAttributeValue("repeat-content", this.getElement().getNamespace("style")), false);
        }

        public final boolean isShrinkToFit() {
            return StyleTableCellProperties.parseBoolean(this.getAttributeValue("shrink-to-fit", this.getElement().getNamespace("style")), false);
        }

        public final Integer getDecimalPlaces() {
            return StyleTableCellProperties.parseInteger(this.getAttributeValue("decimal-places", this.getElement().getNamespace("style")));
        }
    }
}

