/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.spreadsheet;

import org.jdom.Attribute;
import org.jdom.Element;
import org.jopendocument.dom.StyleProperties;

public final class Axis
extends Enum<Axis> {
    public static final /* enum */ Axis ROW = new Axis("row");
    public static final /* enum */ Axis COLUMN = new Axis("column");
    private final String shortName;
    private final String elemName;
    private final String headerName;
    private final String groupName;
    private final String pluralName;
    private final String repeatedAttrName;
    private static final /* synthetic */ Axis[] $VALUES;

    public static Axis[] values() {
        return (Axis[])$VALUES.clone();
    }

    public static Axis valueOf(String string) {
        return Enum.valueOf(Axis.class, string);
    }

    private Axis(String string2) {
        this.shortName = string2;
        this.elemName = "table-" + string2;
        this.headerName = "table-header-" + string2 + "s";
        this.groupName = this.elemName + "-group";
        this.pluralName = this.elemName + "s";
        this.repeatedAttrName = "number-" + string2 + "s-repeated";
    }

    public final String getShortName() {
        return this.shortName;
    }

    public final String getElemName() {
        return this.elemName;
    }

    public final String getHeaderName() {
        return this.headerName;
    }

    public final String getGroupName() {
        return this.groupName;
    }

    public final String getPluralName() {
        return this.pluralName;
    }

    public final String getRepeatedAttrName() {
        return this.repeatedAttrName;
    }

    final Attribute getRepeatedAttr(Element element) {
        assert (element.getName().equals(this.getElemName()));
        return element.getAttribute(this.getRepeatedAttrName(), element.getNamespace());
    }

    final int getRepeated(Element element) {
        assert (element.getName().equals(this.getElemName()));
        return StyleProperties.parseInt(element.getAttributeValue(this.getRepeatedAttrName(), element.getNamespace()), 1);
    }

    final void setRepeated(Element element, int n) {
        assert (element.getName().equals(this.getElemName()));
        if (n < 1) {
            throw new IllegalArgumentException("repeated <1 : " + n);
        }
        if (n == 1) {
            element.removeAttribute(this.getRepeatedAttrName(), element.getNamespace());
        } else {
            element.setAttribute(this.getRepeatedAttrName(), String.valueOf(n), element.getNamespace());
        }
    }

    static {
        $VALUES = new Axis[]{ROW, COLUMN};
    }
}

