/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.util.HashMap;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jopendocument.dom.OOXML;
import org.jopendocument.dom.XMLVersion;
import org.jopendocument.util.CompareUtils;

public final class XMLFormatVersion {
    private static Map<XMLFormatVersion, XMLFormatVersion> instances = new HashMap<XMLFormatVersion, XMLFormatVersion>();
    private static final XMLFormatVersion OOo = XMLFormatVersion.get(XMLVersion.OOo, "1.0");
    private final XMLVersion xmlVersion;
    private final String officeVersion;
    private OOXML xml;

    public static XMLFormatVersion getOOo() {
        return OOo;
    }

    public static XMLFormatVersion getDefault() {
        return OOXML.getDefault().getFormatVersion();
    }

    public static XMLFormatVersion get(Document document) {
        return XMLFormatVersion.get(document.getRootElement());
    }

    public static XMLFormatVersion get(Element element) {
        XMLVersion xMLVersion = XMLVersion.getVersion(element);
        return XMLFormatVersion.get(xMLVersion, element.getAttributeValue("version", xMLVersion.getOFFICE()));
    }

    public static XMLFormatVersion get(XMLVersion xMLVersion, String string) {
        XMLFormatVersion xMLFormatVersion = new XMLFormatVersion(xMLVersion, string);
        XMLFormatVersion xMLFormatVersion2 = instances.get(xMLFormatVersion);
        if (xMLFormatVersion2 == null) {
            xMLFormatVersion2 = xMLFormatVersion;
            instances.put(xMLFormatVersion2, xMLFormatVersion2);
        }
        return xMLFormatVersion2;
    }

    private XMLFormatVersion(XMLVersion xMLVersion, String string) {
        if (xMLVersion == null) {
            throw new NullPointerException("Null XMLVersion");
        }
        this.xmlVersion = xMLVersion;
        this.officeVersion = string;
        this.xml = null;
    }

    public final XMLVersion getXMLVersion() {
        return this.xmlVersion;
    }

    public final String getOfficeVersion() {
        return this.officeVersion;
    }

    public final OOXML getXML() {
        if (this.xml == null) {
            this.xml = OOXML.get(this);
        }
        return this.xml;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.officeVersion == null ? 0 : this.officeVersion.hashCode());
        n = 31 * n + this.xmlVersion.hashCode();
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        XMLFormatVersion xMLFormatVersion = (XMLFormatVersion)object;
        return this.xmlVersion == xMLFormatVersion.xmlVersion && CompareUtils.equals(this.officeVersion, xMLFormatVersion.officeVersion);
    }

    public String toString() {
        return super.toString() + " " + (Object)((Object)this.getXMLVersion()) + " version " + this.getOfficeVersion();
    }
}

