/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.Parent;
import org.jdom.Text;
import org.jdom.xpath.XPath;
import org.jopendocument.dom.LengthUnit;
import org.jopendocument.dom.OOUtils;
import org.jopendocument.dom.XMLFormatVersion;
import org.jopendocument.dom.XMLVersion;
import org.jopendocument.util.CollectionUtils;
import org.jopendocument.util.JDOMUtils;
import org.jopendocument.util.Validator;
import org.xml.sax.SAXException;

public abstract class OOXML
implements Comparable<OOXML> {
    public static final String LAST_FOR_UNKNOWN_PROP = OOXML.class.getPackage().getName() + ".lastOOXMLForUnknownVersion";
    private static final XML_OO instanceOO = new XML_OO();
    private static final SortedMap<String, XML_OD> instancesODByDate = new TreeMap<String, XML_OD>();
    private static final Map<String, XML_OD> instancesODByVersion = new HashMap<String, XML_OD>();
    private static final List<OOXML> values;
    private static OOXML defaultInstance;
    private final XMLFormatVersion version;
    private final String dateString;

    private static void register(XML_OD xML_OD) {
        assert (xML_OD.getVersion() == XMLVersion.OD);
        instancesODByDate.put(xML_OD.getDateString(), xML_OD);
        instancesODByVersion.put(xML_OD.getFormatVersion().getOfficeVersion(), xML_OD);
    }

    public static OOXML get(XMLFormatVersion xMLFormatVersion) {
        return OOXML.get(xMLFormatVersion, Boolean.getBoolean(LAST_FOR_UNKNOWN_PROP));
    }

    public static OOXML get(XMLFormatVersion xMLFormatVersion, boolean bl) {
        if (xMLFormatVersion.getXMLVersion() == XMLVersion.OOo) {
            return instanceOO;
        }
        XML_OD xML_OD = instancesODByVersion.get(xMLFormatVersion.getOfficeVersion());
        if (xML_OD == null && bl) {
            return OOXML.getLast(xMLFormatVersion.getXMLVersion());
        }
        return xML_OD;
    }

    public static OOXML get(Element element) {
        return XMLFormatVersion.get(element).getXML();
    }

    public static final List<OOXML> values() {
        return values;
    }

    public static final OOXML getLast() {
        return CollectionUtils.getLast(values);
    }

    public static final OOXML getLast(XMLVersion xMLVersion) {
        if (xMLVersion == XMLVersion.OOo) {
            return instanceOO;
        }
        return (OOXML)instancesODByDate.get(instancesODByDate.lastKey());
    }

    public static void setDefault(OOXML oOXML) {
        defaultInstance = oOXML;
    }

    public static OOXML getDefault() {
        return defaultInstance;
    }

    private static final String rt2oo(String string, String string2, String string3) {
        return string.replaceAll("\\[" + string2 + "\\]", "<text:span text:style-name=\"" + string3 + "\">").replaceAll("\\[/" + string2 + "\\]", "</text:span>");
    }

    private static final BigDecimal parseCoordinate(Element element, String string, Namespace namespace, LengthUnit lengthUnit) {
        return OOXML.parseLength(element, string, namespace, lengthUnit);
    }

    private static final BigDecimal parseLength(Element element, String string, Namespace namespace, LengthUnit lengthUnit) {
        String string2 = element.getAttributeValue(string, namespace);
        if (string2 == null) {
            return null;
        }
        return LengthUnit.parseLength(string2, lengthUnit);
    }

    private OOXML(XMLFormatVersion xMLFormatVersion, String string) {
        this.version = xMLFormatVersion;
        this.dateString = string;
    }

    public final String getDateString() {
        return this.dateString;
    }

    @Override
    public int compareTo(OOXML oOXML) {
        return this.dateString.compareTo(oOXML.dateString);
    }

    public final XMLVersion getVersion() {
        return this.getFormatVersion().getXMLVersion();
    }

    public final XMLFormatVersion getFormatVersion() {
        return this.version;
    }

    public abstract boolean canValidate();

    public abstract Validator getValidator(Document var1);

    public abstract String[] getFontDecls();

    public final Element getLineBreak() {
        return new Element("line-break", this.getVersion().getTEXT());
    }

    public abstract Element getTab();

    public abstract String getFrameQName();

    public abstract Element createFormattingProperties(String var1);

    protected final List encodeRT_L(String string, Map<String, String> map) {
        String string2 = JDOMUtils.OUTPUTTER.escapeElementEntities(string);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            string2 = OOXML.rt2oo(string2, entry.getKey(), entry.getValue());
        }
        try {
            return JDOMUtils.parseString(string2, this.getVersion().getALL());
        }
        catch (JDOMException jDOMException) {
            throw new IllegalStateException("could not parse " + string2, jDOMException);
        }
    }

    public final Element encodeRT(String string, Map<String, String> map) {
        return new Element("span", this.getVersion().getTEXT()).addContent(this.encodeRT_L(string, map));
    }

    private Element createSpaces(String string) {
        return new Element("s", this.getVersion().getTEXT()).setAttribute("c", string.length() + "", this.getVersion().getTEXT());
    }

    public final Element encodeWS(String string) {
        return new Element("span", this.getVersion().getTEXT()).setContent(this.encodeWSasList(string));
    }

    public final List<Content> encodeWSasList(String string) {
        ArrayList<Content> arrayList = new ArrayList<Content>();
        Matcher matcher = Pattern.compile("\n|\t| {2,}").matcher(string);
        int n = 0;
        while (matcher.find()) {
            arrayList.add(new Text(string.substring(n, matcher.start())));
            switch (matcher.group().charAt(0)) {
                case '\n': {
                    arrayList.add(this.getLineBreak());
                    break;
                }
                case '\t': {
                    arrayList.add(this.getTab());
                    break;
                }
                case ' ': {
                    arrayList.add(this.createSpaces(matcher.group()));
                    break;
                }
                default: {
                    throw new IllegalStateException("unknown item: " + matcher.group());
                }
            }
            n = matcher.end();
        }
        arrayList.add(new Text(string.substring(n)));
        return arrayList;
    }

    public final void encodeWS(Text text) {
        Parent parent = text.getParent();
        int n = parent.indexOf(text);
        text.detach();
        parent.getContent().addAll(n, this.encodeWSasList(text.getText()));
    }

    public final Element encodeWS(Element element) {
        XPath xPath;
        try {
            xPath = OOUtils.getXPath(".//text()", this.getVersion());
        }
        catch (JDOMException jDOMException) {
            throw new IllegalStateException("cannot create XPath", jDOMException);
        }
        try {
            for (Text text : new ArrayList(xPath.selectNodes(element))) {
                this.encodeWS(text);
            }
        }
        catch (JDOMException jDOMException) {
            throw new IllegalArgumentException("cannot find text nodes of " + element, jDOMException);
        }
        return element;
    }

    public final BigDecimal[] getCoordinates(Element element, LengthUnit lengthUnit) {
        return this.getCoordinates(element, lengthUnit, true, true);
    }

    public final BigDecimal[] getCoordinates(Element element, LengthUnit lengthUnit, boolean bl, boolean bl2) {
        return OOXML.getCoordinates(element, this.getVersion().getNS("svg"), lengthUnit, bl, bl2);
    }

    private static final BigDecimal[] getCoordinates(Element element, Namespace namespace, LengthUnit lengthUnit, boolean bl, boolean bl2) {
        if (element.getName().equals("g") && element.getNamespacePrefix().equals("draw")) {
            if (!bl && !bl2) {
                return new BigDecimal[]{null, null, null, null};
            }
            BigDecimal bigDecimal = null;
            BigDecimal bigDecimal2 = null;
            BigDecimal bigDecimal3 = null;
            BigDecimal bigDecimal4 = null;
            for (Object e : element.getChildren()) {
                Element element2 = (Element)e;
                BigDecimal[] bigDecimalArray = OOXML.getCoordinates(element2, namespace, lengthUnit, bl, bl2);
                if (bigDecimalArray == null) continue;
                BigDecimal bigDecimal5 = bigDecimalArray[0];
                BigDecimal bigDecimal6 = bigDecimalArray[2];
                if (bigDecimal5 != null) {
                    assert (bigDecimal6 != null);
                    if (bigDecimal == null || bigDecimal5.compareTo(bigDecimal) < 0) {
                        bigDecimal = bigDecimal5;
                    }
                    if (bigDecimal3 == null || bigDecimal6.compareTo(bigDecimal3) > 0) {
                        bigDecimal3 = bigDecimal6;
                    }
                }
                bigDecimal5 = bigDecimalArray[1];
                bigDecimal6 = bigDecimalArray[3];
                if (bigDecimal5 == null) continue;
                assert (bigDecimal6 != null);
                if (bigDecimal2 == null || bigDecimal5.compareTo(bigDecimal2) < 0) {
                    bigDecimal2 = bigDecimal5;
                }
                if (bigDecimal4 != null && bigDecimal6.compareTo(bigDecimal4) <= 0) continue;
                bigDecimal4 = bigDecimal6;
            }
            if (bigDecimal == null && bigDecimal2 == null) {
                throw new IllegalArgumentException("Empty group : " + JDOMUtils.output(element));
            }
            return new BigDecimal[]{bigDecimal, bigDecimal2, bigDecimal3, bigDecimal4};
        }
        return OOXML.getLocalCoordinates(element, namespace, lengthUnit, bl, bl2);
    }

    private static final BigDecimal[] getLocalCoordinates(Element element, Namespace namespace, LengthUnit lengthUnit, boolean bl, boolean bl2) {
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2;
        BigDecimal bigDecimal3;
        BigDecimal bigDecimal4;
        BigDecimal bigDecimal5 = OOXML.parseCoordinate(element, "x", namespace, lengthUnit);
        BigDecimal bigDecimal6 = OOXML.parseCoordinate(element, "x1", namespace, lengthUnit);
        if (bigDecimal5 == null && bigDecimal6 == null) {
            return null;
        }
        BigDecimal bigDecimal7 = OOXML.parseCoordinate(element, "y", namespace, lengthUnit);
        BigDecimal bigDecimal8 = OOXML.parseCoordinate(element, "y1", namespace, lengthUnit);
        if (bigDecimal7 == null && bigDecimal8 == null) {
            throw new IllegalArgumentException("Have x but missing y in " + JDOMUtils.output(element));
        }
        if (bl) {
            if (bigDecimal5 == null) {
                bigDecimal4 = bigDecimal6;
                bigDecimal3 = OOXML.parseCoordinate(element, "x2", namespace, lengthUnit);
            } else {
                bigDecimal4 = bigDecimal5;
                bigDecimal2 = OOXML.parseLength(element, "width", namespace, lengthUnit);
                BigDecimal bigDecimal9 = bigDecimal3 = bigDecimal2 == null ? null : bigDecimal4.add(bigDecimal2);
            }
            if (bigDecimal3 == null) {
                return null;
            }
        } else {
            bigDecimal4 = null;
            bigDecimal3 = null;
        }
        if (bl2) {
            if (bigDecimal7 == null) {
                bigDecimal2 = bigDecimal8;
                bigDecimal = OOXML.parseCoordinate(element, "y2", namespace, lengthUnit);
            } else {
                bigDecimal2 = bigDecimal7;
                BigDecimal bigDecimal10 = OOXML.parseLength(element, "height", namespace, lengthUnit);
                BigDecimal bigDecimal11 = bigDecimal = bigDecimal10 == null ? null : bigDecimal2.add(bigDecimal10);
            }
            if (bigDecimal == null) {
                return null;
            }
        } else {
            bigDecimal2 = null;
            bigDecimal = null;
        }
        return new BigDecimal[]{bigDecimal4, bigDecimal2, bigDecimal3, bigDecimal};
    }

    static {
        OOXML.register(new XML_OD_1_0());
        OOXML.register(new XML_OD_1_1());
        OOXML.register(new XML_OD_1_2());
        values = new ArrayList<OOXML>(instancesODByDate.size() + 1);
        values.add(instanceOO);
        values.addAll(instancesODByDate.values());
        OOXML.setDefault(OOXML.getLast());
    }

    private static final class XML_OD_1_2
    extends XML_OD {
        public XML_OD_1_2() {
            super("20110317", "1.2", "OpenDocument-v1.2-schema.rng");
        }
    }

    private static final class XML_OD_1_1
    extends XML_OD {
        public XML_OD_1_1() {
            super("20070201", "1.1", "OpenDocument-strict-schema-v1.1.rng");
        }
    }

    private static final class XML_OD_1_0
    extends XML_OD {
        public XML_OD_1_0() {
            super("20061130", "1.0", null);
        }
    }

    private static class XML_OD
    extends OOXML {
        private final String schemaFile;
        private Schema schema = null;

        public XML_OD(String string, String string2, String string3) {
            super(XMLFormatVersion.get(XMLVersion.OD, string2), string);
            this.schemaFile = string3;
        }

        @Override
        public boolean canValidate() {
            return this.schemaFile != null;
        }

        private Schema getSchema() throws SAXException {
            if (this.schema == null && this.schemaFile != null) {
                this.schema = SchemaFactory.newInstance("http://relaxng.org/ns/structure/1.0").newSchema(this.getClass().getResource("oofficeDTDs/" + this.schemaFile));
            }
            return this.schema;
        }

        @Override
        public Validator getValidator(Document document) {
            Schema schema;
            try {
                schema = this.getSchema();
            }
            catch (SAXException sAXException) {
                throw new IllegalStateException("relaxNG schemas pb", sAXException);
            }
            return schema == null ? null : new Validator.JAXPValidator(document, schema);
        }

        @Override
        public final String[] getFontDecls() {
            return new String[]{"font-face-decls", "style:font-face"};
        }

        @Override
        public final Element getTab() {
            return new Element("tab", this.getVersion().getTEXT());
        }

        @Override
        public String getFrameQName() {
            return "draw:frame";
        }

        @Override
        public Element createFormattingProperties(String string) {
            return new Element(string + "-properties", this.getVersion().getSTYLE());
        }
    }

    private static final class XML_OO
    extends OOXML {
        public XML_OO() {
            super(XMLFormatVersion.getOOo(), "20020501");
        }

        @Override
        public boolean canValidate() {
            return true;
        }

        @Override
        public Validator getValidator(Document document) {
            for (Namespace namespace : this.getVersion().getALL()) {
                document.getRootElement().addNamespaceDeclaration(namespace);
            }
            return new Validator.DTDValidator(document, OOUtils.getBuilderLoadDTD());
        }

        @Override
        public String[] getFontDecls() {
            return new String[]{"font-decls", "style:font-decl"};
        }

        @Override
        public final Element getTab() {
            return new Element("tab-stop", this.getVersion().getTEXT());
        }

        @Override
        public String getFrameQName() {
            return "draw:text-box";
        }

        @Override
        public Element createFormattingProperties(String string) {
            return new Element("properties", this.getVersion().getSTYLE());
        }
    }
}

