/*
 * Decompiled with CFR 0.152.
 */
package org.jopenchart.barchart;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.jopenchart.Chart;
import org.jopenchart.DataModel1D;
import org.jopenchart.DataModelMultiple;

public class BarChart
extends Chart {
    Integer spaceBetweenBars;
    Integer spaceBetweenGroups;
    int barWidth;
    private Number lowerRange;
    private Number higherRange;

    BarChart() {
        this.model = new DataModelMultiple();
        this.barWidth = 10;
    }

    public void addModel(DataModel1D model) {
        model.setChart(this);
        this.getDataModel().addModel(model);
    }

    public int getModelNumber() {
        return this.getDataModel().getSize();
    }

    public DataModel1D getModel(int index) {
        return this.getDataModel().getModel(index);
    }

    public void setBarWidth(Integer barWidth) {
        this.barWidth = barWidth;
    }

    public int getBarWidth() {
        return this.barWidth;
    }

    public Integer getSpaceBetweenBars() {
        if (this.spaceBetweenBars == null) {
            return this.getSpaceBetweenGroups() / 2;
        }
        return this.spaceBetweenBars;
    }

    public void setSpaceBetweenBars(Integer space) {
        this.spaceBetweenBars = space;
    }

    public Integer getSpaceBetweenGroups() {
        if (this.spaceBetweenGroups == null) {
            return 8;
        }
        return this.spaceBetweenGroups;
    }

    public void setSpaceBetweenGroups(Integer space) {
        this.spaceBetweenGroups = space;
    }

    public int getBarNumber() {
        int r = 0;
        int i = 0;
        while (i < this.getDataModel().getSize()) {
            DataModel1D m = this.getDataModel().getModel(i);
            int s = m.getSize();
            if (s > r) {
                r = s;
            }
            ++i;
        }
        return r;
    }

    public Number getLowerRange() {
        return this.lowerRange;
    }

    public Number getHigherRange() {
        return this.higherRange;
    }

    @Override
    public DataModelMultiple getDataModel() {
        return (DataModelMultiple)this.model;
    }

    public void setLowerRange(Number i) {
        this.lowerRange = i;
    }

    public void setHigherRange(Number i) {
        this.higherRange = i;
    }

    @Override
    public void prepareRendering(Graphics2D g) {
        Dimension dimension = this.getDimension();
        if (dimension == null) {
            throw new IllegalStateException("Chart dimensions not defined");
        }
        int leftWidth = 1 + this.left.getMaxLabelWidth(g) + this.left.getMarkerLenght() + this.left.getMarkerSpacing();
        int rightWidth = this.bottom.getMaxLabelWidth(g) / 2;
        int topHeight = this.left.getMaxLabelHeight(g) / 2;
        int bottomHeight = 1 + this.bottom.getMaxLabelHeight(g) + this.bottom.getMarkerLenght() + this.bottom.getMarkerSpacing() + this.left.getMaxLabelHeight(g) / 2;
        int graphWidth = dimension.width - leftWidth - rightWidth;
        int graphHeight = dimension.height - topHeight - bottomHeight;
        this.left.setX(0);
        this.left.setY(topHeight);
        this.left.setWidth(leftWidth);
        this.left.setHeight(graphHeight);
        this.bottom.setX(leftWidth - 1);
        this.bottom.setY(topHeight + graphHeight);
        this.bottom.setWidth(graphWidth);
        this.bottom.setHeight(bottomHeight);
        this.setChartRectangle(new Rectangle(leftWidth, topHeight, graphWidth, graphHeight));
    }
}

