/*
 * Decompiled with CFR 0.152.
 */
package org.jopenchart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import org.jopenchart.Axis;
import org.jopenchart.AxisLabel;
import org.jopenchart.Chart;
import org.jopenchart.ChartPanel;
import org.jopenchart.DataModel1D;
import org.jopenchart.Label;
import org.jopenchart.barchart.VerticalStackBarChart;
import org.jopenchart.linechart.LineChart;
import org.jopenchart.marker.CircleMarker;
import org.jopenchart.marker.ShapeMarker;
import org.jopenchart.piechart.PieChart;
import org.jopenchart.sample.model.DataModel1DDynamic;
import org.jopenchart.sample.model.DataModel1DFuzzy;

public class URLParser {
    final Map<String, String> parameters = new HashMap<String, String>();
    int[] valueOf = new int[128];
    String simpleEncoding = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";

    public URLParser(String url) {
        int i = 0;
        while (i < this.simpleEncoding.length()) {
            this.valueOf[this.simpleEncoding.charAt((int)i)] = i;
            ++i;
        }
        int s = url.indexOf(63);
        String allparams = url.substring(s);
        String buff = "";
        String key = "";
        String value = "";
        int length = allparams.length();
        int i2 = 1;
        while (i2 < length) {
            char c = allparams.charAt(i2);
            if (c == '&') {
                value = buff;
                buff = "";
                this.parameters.put(key, value);
            } else if (c == '=') {
                key = buff;
                buff = "";
            } else {
                buff = String.valueOf(buff) + c;
            }
            ++i2;
        }
        value = buff;
        this.parameters.put(key, value);
    }

    public static void main(String[] args) {
        URLParser.testDynamicBarChart();
    }

    private static void testDynamicBarChart() {
        VerticalStackBarChart c = new VerticalStackBarChart();
        c.setColor(new Color(0, 155, 100));
        Axis axis = new Axis("y");
        axis.addLabel(new AxisLabel("0%"));
        axis.addLabel(new AxisLabel("100%"));
        c.setDimension(new Dimension(400, 300));
        c.addModel(new DataModel1DDynamic(c));
        c.setLowerRange(0);
        c.setHigherRange(100);
        ChartPanel panel = new ChartPanel(c);
        JFrame f = new JFrame("Test");
        f.setContentPane(panel);
        f.setDefaultCloseOperation(3);
        f.setSize(600, 500);
        f.setVisible(true);
    }

    private static void testDynamicChart() {
        LineChart c = new LineChart();
        c.setColor(new Color(0, 155, 100));
        c.setFillColor(Color.LIGHT_GRAY);
        Axis axis = new Axis("y");
        axis.addLabel(new AxisLabel("0%"));
        axis.addLabel(new AxisLabel("100%"));
        c.setLeftAxis(axis);
        c.setDimension(new Dimension(400, 300));
        c.setDataModel(new DataModel1DFuzzy());
        c.setLowerRange(0);
        c.setHigherRange(100);
        ChartPanel panel = new ChartPanel(c);
        JFrame f = new JFrame("Test");
        f.setContentPane(panel);
        f.setDefaultCloseOperation(3);
        f.setSize(600, 500);
        f.setVisible(true);
    }

    private static void testDynamicPieChart() {
        PieChart c = new PieChart();
        c.setColor(new Color(0, 0, 0));
        c.setInnerDimension(20, 20);
        c.setInnerColor(Color.WHITE);
        Axis axis = new Axis("y");
        axis.addLabel(new AxisLabel("0%"));
        axis.addLabel(new AxisLabel("100%"));
        c.setDimension(new Dimension(200, 125));
        Number[] d = new Number[]{50, 20, 80, 30};
        c.setDataModel(new DataModel1D(d));
        ChartPanel panel = new ChartPanel(c);
        JFrame f = new JFrame("Test");
        f.setContentPane(panel);
        f.setDefaultCloseOperation(3);
        f.setSize(600, 500);
        f.setVisible(true);
    }

    private static void testURL() {
        String url = "http://chart.apis.google.com/chart?cht=lc&chs=400x200&chd=s:9fohmnytenefoh__m_ny_tene&chxt=x,y&chxl=0:|Apr|May|June|1:|0|50+Kb";
        url = "http://chart.apis.google.com/chart?cht=lc&chs=200x125&chd=s:helloWorld&chxt=x,y&chxl=0:|Mar|Apr|May|June|July|1:||50+Kb";
        url = "http://chart.apis.google.com/chart?cht=p&chd=s:world5&chs=200x125&chl=A|B|C|D|E|F";
        url = "http://chart.apis.google.com/chart?cht=bvs&chs=200x125&chd=s:hello,world&chco=cc0000,00aa00&chbh=20";
        url = "http://chart.apis.google.com/chart?cht=lc&chd=s:cEAELFJHHHKUju9uuXUc&chco=76A4FB&chls=2.0,0.0,0.0&chxt=x,y&chxl=0:|0|1|2|3|4|5|1:|0|50|100&chs=200x125&chg=20,50";
        url = "http://chart.apis.google.com/chart?cht=lc&chd=s:93zyvneTTOMJMLIJFHEAECFJGHDBFCFIERcgnpy45879,IJKNUWUWYdnswz047977315533zy1246872tnkgcaZQONHCECAAAAEII&chls=3,6,3|1,1,0&chs=200x125";
        url = "http://chart.apis.google.com/chart?cht=lc&chd=s:9gounjqGJD&chco=008000&chls=2.0,4.0,1.0&chs=200x125&chxt=x&chxl=0:||c|d|a|o|x|v|V|a|&chm=a,990066,0,3.0,9.0|c,FF0000,0,1.0,20.0|d,80C65A,0,2.0,20.0|o,FF9900,0,4.0,20.0|s,3399CC,0,5.0,10.0|v,BBCCED,0,6.0,1.0|V,3399CC,0,7.0,1.0|x,FFCC33,0,8.0,20.0|h,000000,0,0.30,0.5";
        URLParser p = new URLParser(url);
        Chart c = p.getChart();
        ChartPanel panel = new ChartPanel(c);
        JFrame f = new JFrame("Test");
        f.setContentPane(panel);
        f.setDefaultCloseOperation(3);
        f.setSize(600, 500);
        f.setVisible(true);
    }

    public Chart getChart() {
        String type = this.parameters.get("cht");
        if (type == null) {
            return null;
        }
        if (type.equals("lc")) {
            LineChart chart = new LineChart();
            chart.setDimension(this.getDimension(this.parameters.get("chs")));
            this.setRange(chart, this.parameters.get("chd"));
            chart.setMultipleData(this.getMultipleData(chart, this.parameters.get("chd")));
            chart.setColors(this.getColors(this.parameters.get("chco")));
            if (this.parameters.get("chls") != null) {
                chart.setStrokes(this.getStrokes(this.parameters.get("chls")));
            }
            List<Axis> axis = this.getAxis(this.parameters.get("chxt"), this.parameters.get("chxl"));
            for (Axis axis2 : axis) {
                if (axis2.getLabel().equals("x")) {
                    chart.setBottomAxis(axis2);
                    continue;
                }
                if (!axis2.getLabel().equals("y")) continue;
                chart.setLeftAxis(axis2);
            }
            this.setGrid(chart, this.parameters.get("chg"));
            chart.addMarkers(this.getMarkers(this.parameters.get("chm")));
            return chart;
        }
        if (type.equals("p")) {
            PieChart chart = new PieChart();
            chart.setDimension(this.getDimension(this.parameters.get("chs")));
            chart.setData(this.getData(chart, this.parameters.get("chd")));
            if (this.parameters.get("chl") != null) {
                List<Label> labels = this.getLabels(this.parameters.get("chl"));
                for (Label label : labels) {
                    chart.addLabel(label);
                }
            }
            return chart;
        }
        if (type.equals("bvs")) {
            VerticalStackBarChart chart = new VerticalStackBarChart();
            chart.setDimension(this.getDimension(this.parameters.get("chs")));
            chart.setColors(this.getColors(this.parameters.get("chco")));
            chart.setBarWidth(this.getBarWidth(this.parameters.get("chbh")));
            chart.setSpaceBetweenBars(this.getSpaceBetweenBars(this.parameters.get("chbh")));
            chart.setSpaceBetweenGroups(this.getSpaceBetweenGroups(this.parameters.get("chbh")));
            return chart;
        }
        return null;
    }

    private List<ShapeMarker> getMarkers(String string) {
        if (string == null) {
            return Collections.EMPTY_LIST;
        }
        String[] params = this.splitPipe(string);
        ArrayList<ShapeMarker> list = new ArrayList<ShapeMarker>();
        int i = 0;
        while (i < params.length) {
            list.add(this.getMarker(params[i]));
            ++i;
        }
        return list;
    }

    private ShapeMarker getMarker(String string) {
        String[] params = string.split(",");
        CircleMarker c = new CircleMarker();
        c.setColor(Color.decode("#" + params[1]));
        c.setDataSetIndex(Integer.parseInt(params[2]));
        c.setData(Double.parseDouble(params[3]));
        c.setSize(Float.parseFloat(params[4]));
        return c;
    }

    private List<Stroke> getStrokes(String string) {
        ArrayList<Stroke> list = new ArrayList<Stroke>();
        String[] params = this.splitPipe(string);
        int i = 0;
        while (i < params.length) {
            list.add(this.getSroke(params[i]));
            ++i;
        }
        return list;
    }

    private Stroke getSroke(String string) {
        String[] params = string.split(",");
        float thickness = Float.parseFloat(params[0]);
        float lineLength = Float.parseFloat(params[1]);
        float blankLenght = Float.parseFloat(params[2]);
        return new BasicStroke(thickness, 0, 1, 0.0f, new float[]{lineLength, blankLenght}, 0.0f);
    }

    private void setGrid(LineChart chart, String string) {
        if (string == null) {
            return;
        }
        String[] params = string.split(",");
        if (params.length > 0) {
            Double dx = Double.parseDouble(params[0]);
            chart.setGridXStep(dx);
            if (params.length > 1) {
                Double dy = Double.parseDouble(params[1]);
                chart.setGridYStep(dy);
                if (params.length > 2) {
                    Float li = Float.valueOf(Float.parseFloat(params[2]));
                    chart.setGridSegment(li.floatValue(), 3.0f);
                    if (params.length > 3) {
                        Float bl = Float.valueOf(Float.parseFloat(params[3]));
                        chart.setGridSegment(li.floatValue(), bl.floatValue());
                    }
                }
            }
        }
    }

    private List<List<Number>> getMultipleData(LineChart chart, String string) {
        ArrayList<List<Number>> r = new ArrayList<List<Number>>();
        if (string.startsWith("s:")) {
            if (chart.getLowerRange() == null) {
                chart.setLowerRange(0);
            }
            if (chart.getHigherRange() == null) {
                chart.setHigherRange(61);
            }
            string = string.substring(2);
            String[] params = string.split(",");
            int i = 0;
            while (i < params.length) {
                String p = params[i];
                r.add(this.getSimpleEncodedData(p));
                ++i;
            }
        }
        return r;
    }

    private Integer getSpaceBetweenBars(String string) {
        String[] params = string.split(",");
        if (params.length > 1) {
            return Integer.valueOf(params[1]);
        }
        return null;
    }

    private Integer getSpaceBetweenGroups(String string) {
        String[] params = string.split(",");
        if (params.length > 2) {
            return Integer.valueOf(params[2]);
        }
        return null;
    }

    private Integer getBarWidth(String string) {
        String[] params = string.split(",");
        if (params.length > 0) {
            return Integer.valueOf(params[0]);
        }
        return null;
    }

    private List<Color> getColors(String string) {
        if (string == null) {
            return Collections.EMPTY_LIST;
        }
        String[] colors = string.split(",");
        ArrayList<Color> result = new ArrayList<Color>(colors.length);
        int i = 0;
        while (i < colors.length) {
            String color = colors[i];
            Color c = Color.BLACK;
            try {
                c = Color.decode("#" + color);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot parse color: " + color);
            }
            result.add(c);
            ++i;
        }
        return result;
    }

    private List<Label> getLabels(String labels) {
        String[] t = this.splitPipe(labels);
        ArrayList<Label> result = new ArrayList<Label>(t.length);
        int j = 0;
        while (j < t.length) {
            String label = t[j];
            label = label.replace('+', ' ');
            result.add(new Label(label));
            ++j;
        }
        return result;
    }

    private void setRange(LineChart chart, String string) {
        int index = string.indexOf("s:");
        if (index == 0) {
            chart.setLowerRange(0);
            chart.setHigherRange(61);
        }
    }

    private List<Axis> getAxis(String string, String string2) {
        int i;
        ArrayList<Axis> r = new ArrayList<Axis>(1);
        System.out.println("getAxis");
        System.out.println("s1:" + string);
        System.out.println("s2:" + string2);
        String[] axisTypes = null;
        String[] axisLabels = null;
        if (string != null) {
            axisTypes = string.split(",");
            i = 0;
            while (i < axisTypes.length) {
                String t = axisTypes[i];
                r.add(new Axis(t));
                ++i;
            }
        }
        if (string2 != null) {
            axisLabels = string2.split("[0-9]+:");
            i = 0;
            while (i < axisLabels.length - 1) {
                String labels = axisLabels[i + 1];
                System.out.println("=================================" + string2);
                System.out.println(String.valueOf(i) + ":" + labels);
                Axis axis = (Axis)r.get(i);
                String[] t = this.splitPipe(labels);
                int j = 1;
                while (j < t.length) {
                    String label = t[j];
                    label = label.replace('+', ' ');
                    axis.addLabel(new AxisLabel(label));
                    ++j;
                }
                System.out.println(axis.getLabels());
                ++i;
            }
        }
        return r;
    }

    private String[] splitPipe(String labels) {
        ArrayList<String> l = new ArrayList<String>();
        String t = "";
        int i = 0;
        while (i < labels.length()) {
            char c = labels.charAt(i);
            if (c == '|') {
                l.add(t);
                t = "";
            } else {
                t = String.valueOf(t) + c;
            }
            ++i;
        }
        if (t.length() > 0) {
            l.add(t);
        }
        return l.toArray(new String[0]);
    }

    private List<Number> getData(Chart chart, String string) {
        List<Number> r = null;
        int index = string.indexOf("s:");
        if (index == 0) {
            string = string.substring(2);
            r = this.getSimpleEncodedData(string);
        }
        return r;
    }

    private List<Number> getSimpleEncodedData(String string) {
        ArrayList<Number> r = new ArrayList<Number>();
        int i = 0;
        while (i < string.length()) {
            char c1 = string.charAt(i);
            if (c1 == '_') {
                r.add(null);
            } else {
                int value = this.valueOf[c1];
                r.add(value);
            }
            ++i;
        }
        return r;
    }

    private Dimension getDimension(String string) {
        int i = string.indexOf(120);
        if (i > 0) {
            String ws = string.substring(0, i);
            String hs = string.substring(i + 1);
            return new Dimension(Integer.valueOf(ws), Integer.valueOf(hs));
        }
        return null;
    }
}

