/*
 * Decompiled with CFR 0.152.
 */
package org.jopenchart;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import org.jopenchart.Chart;
import org.jopenchart.DataModelListener;

public class ChartPanel
extends JPanel
implements DataModelListener,
MouseMotionListener {
    private Chart chart;

    public ChartPanel(Chart c) {
        this.chart = c;
        c.getDataModel().addDataModelListener(this);
        this.setMinimumSize(c.getDimension());
        this.setPreferredSize(c.getDimension());
        this.addMouseMotionListener(this);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.chart.render((Graphics2D)g);
    }

    @Override
    public void dataChanged() {
        this.invalidate();
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Number n = this.chart.highLightAt(e.getX(), e.getY());
        this.setToolTipText(this.getToolTipTextFrom(n));
    }

    public String getToolTipTextFrom(Number n) {
        if (n == null) {
            return null;
        }
        return String.valueOf(n);
    }
}

