/*
 * Decompiled with CFR 0.152.
 */
package org.jedit;

import javax.swing.text.Segment;
import org.jedit.SyntaxUtilities;

public class KeywordMap {
    protected int mapLength;
    private Keyword[] map;
    private boolean ignoreCase;

    public KeywordMap(boolean ignoreCase) {
        this(ignoreCase, 52);
        this.ignoreCase = ignoreCase;
    }

    public KeywordMap(boolean ignoreCase, int mapLength) {
        this.mapLength = mapLength;
        this.ignoreCase = ignoreCase;
        this.map = new Keyword[mapLength];
    }

    public byte lookup(Segment text, int offset, int length) {
        if (length == 0) {
            return 0;
        }
        Keyword k = this.map[this.getSegmentMapKey(text, offset, length)];
        while (k != null) {
            if (length != k.keyword.length) {
                k = k.next;
                continue;
            }
            if (SyntaxUtilities.regionMatches(this.ignoreCase, text, offset, k.keyword)) {
                return k.id;
            }
            k = k.next;
        }
        return 0;
    }

    public void add(String keyword, byte id) {
        int key = this.getStringMapKey(keyword);
        this.map[key] = new Keyword(keyword.toCharArray(), id, this.map[key]);
    }

    public void removeKeyword(String keyword) {
        int key = this.getStringMapKey(keyword);
        Keyword tmp = this.map[key].next;
        Keyword tmpPrevious = this.map[key];
        if (keyword.trim().equals(String.valueOf(tmpPrevious.keyword))) {
            this.map[key] = this.map[key].next;
        }
        while (tmp != null) {
            System.err.println("Keyword " + keyword + " ---> " + String.valueOf(tmp.keyword));
            if (keyword.trim().equals(String.valueOf(tmp.keyword))) {
                System.err.println("Remove Keyword " + keyword + " ---> " + String.valueOf(tmp.keyword));
                System.err.println("now " + tmpPrevious.keyword + "Point on" + tmp.keyword);
                tmpPrevious.next = tmp.next;
                tmp = null;
                break;
            }
            tmpPrevious = tmpPrevious.next;
            tmp = tmp.next;
        }
    }

    public void dumpMap() {
        int i = 0;
        while (i < this.map.length) {
            Keyword tmp = this.map[i];
            System.err.print("Entr\u00e9e " + i + " ---> ");
            while (tmp != null) {
                System.err.print(" " + String.valueOf(tmp.keyword));
                tmp = tmp.next;
            }
            System.err.println(" .__.");
            ++i;
        }
    }

    public boolean isExisting(String keyword) {
        int key = this.getStringMapKey(keyword);
        if (this.map[key] != null) {
            Keyword tmp = this.map[key];
            while (tmp != null) {
                System.err.println("KeyWord " + keyword + " -----> " + String.valueOf(tmp.keyword));
                if (keyword.trim().equals(String.valueOf(tmp.keyword))) {
                    return true;
                }
                tmp = tmp.next;
            }
            return false;
        }
        return false;
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    protected int getStringMapKey(String s) {
        return (Character.toUpperCase(s.charAt(0)) + Character.toUpperCase(s.charAt(s.length() - 1))) % this.mapLength;
    }

    protected int getSegmentMapKey(Segment s, int off, int len) {
        return (Character.toUpperCase(s.array[off]) + Character.toUpperCase(s.array[off + len - 1])) % this.mapLength;
    }

    class Keyword {
        public char[] keyword;
        public byte id;
        public Keyword next;

        public Keyword(char[] keyword, byte id, Keyword next) {
            this.keyword = keyword;
            this.id = id;
            this.next = next;
        }
    }
}

