/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.treetable;

import java.io.File;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;

public class FileNode
extends DefaultMutableTreeNode {
    private final File file;
    private final boolean isDir;

    public FileNode(File file) {
        this.file = file;
        this.isDir = file.isDirectory();
    }

    @Override
    public boolean getAllowsChildren() {
        return this.isDir;
    }

    protected List getChildren() {
        if (this.children == null) {
            try {
                String[] files = this.file.list();
                if (files != null) {
                    this.children = new Vector(files.length);
                    String path = this.file.getPath();
                    int i = 0;
                    while (i < files.length) {
                        File childFile = new File(path, files[i]);
                        this.children.add(new FileNode(childFile));
                        ++i;
                    }
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return this.children;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public boolean isLeaf() {
        return !this.isDir;
    }

    @Override
    public String toString() {
        return this.file.getName();
    }
}

