/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf;

import java.util.Map;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.plaf.ContextMenuSource;

public class TextContextMenuSource
extends ContextMenuSource {
    String UNDO = "Undo";
    String CUT = "Cut";
    String COPY = "Copy";
    String PASTE = "Paste";
    String DELETE = "Delete";
    String SELECT_ALL = "Select All";
    String[] keys;
    String[] defaultValues;

    public TextContextMenuSource() {
        String[] stringArray = new String[6];
        stringArray[0] = "cut-to-clipboard";
        stringArray[1] = "copy-to-clipboard";
        stringArray[2] = "paste-from-clipboard";
        stringArray[3] = "delete-next";
        stringArray[5] = "select-all";
        this.keys = stringArray;
        String[] stringArray2 = new String[6];
        stringArray2[0] = this.CUT;
        stringArray2[1] = this.COPY;
        stringArray2[2] = this.PASTE;
        stringArray2[3] = this.DELETE;
        stringArray2[5] = this.SELECT_ALL;
        this.defaultValues = stringArray2;
    }

    @Override
    public String[] getKeys() {
        return this.keys;
    }

    @Override
    public void updateActionEnabled(JComponent component, ActionMap map) {
        if (!(component instanceof JTextComponent)) {
            return;
        }
        JTextComponent textComponent = (JTextComponent)component;
        boolean selectedText = textComponent.getSelectionEnd() - textComponent.getSelectionStart() > 0;
        boolean containsText = textComponent.getDocument().getLength() > 0;
        boolean editable = textComponent.isEditable();
        boolean copyProtected = textComponent instanceof JPasswordField;
        boolean dataOnClipboard = textComponent.getToolkit().getSystemClipboard().getContents(null) != null;
        map.get("cut-to-clipboard").setEnabled(!copyProtected && editable && selectedText);
        map.get("copy-to-clipboard").setEnabled(!copyProtected && selectedText);
        map.get("paste-from-clipboard").setEnabled(editable && dataOnClipboard);
        map.get("delete-next").setEnabled(editable && selectedText);
        map.get("select-all").setEnabled(containsText);
    }

    @Override
    protected void initNames(Map names) {
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i] != null) {
                names.put(this.keys[i], this.getValue(this.keys[i], this.defaultValues[i]));
            }
            ++i;
        }
    }

    @Override
    protected String getResourcePrefix() {
        return "DefaultEditorKit.";
    }
}

