/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.table.DefaultTableCellRenderer;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.Highlighter;

public class HighlighterPipeline
implements Highlighter.UIHighlighter {
    protected transient ChangeEvent changeEvent = null;
    protected EventListenerList listenerList = new EventListenerList();
    protected List highlighters = new ArrayList();
    private static final Highlighter resetDefaultTableCellRendererHighlighter = new Highlighter(null, null, true){

        @Override
        protected void applyBackground(Component renderer, ComponentAdapter adapter) {
            if (!adapter.isSelected()) {
                renderer.setBackground(null);
            }
        }

        @Override
        protected void applyForeground(Component renderer, ComponentAdapter adapter) {
            if (!adapter.isSelected()) {
                renderer.setForeground(null);
            }
        }
    };
    private ChangeListener highlighterChangeListener;

    public HighlighterPipeline() {
    }

    public HighlighterPipeline(Highlighter[] inList) {
        this();
        int i = 0;
        while (i < inList.length) {
            this.addHighlighter(inList[i]);
            ++i;
        }
    }

    public void addHighlighter(Highlighter hl) {
        this.addHighlighter(hl, false);
    }

    public void addHighlighter(Highlighter hl, boolean prepend) {
        if (prepend) {
            this.highlighters.add(0, hl);
        } else {
            this.highlighters.add(this.highlighters.size(), hl);
        }
        this.updateUI(hl);
        hl.addChangeListener(this.getHighlighterChangeListener());
        this.fireStateChanged();
    }

    private ChangeListener getHighlighterChangeListener() {
        if (this.highlighterChangeListener == null) {
            this.highlighterChangeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    HighlighterPipeline.this.fireStateChanged();
                }
            };
        }
        return this.highlighterChangeListener;
    }

    public void removeHighlighter(Highlighter hl) {
        boolean success = this.highlighters.remove(hl);
        if (success) {
            hl.removeChangeListener(this.getHighlighterChangeListener());
            this.fireStateChanged();
        }
    }

    public Highlighter[] getHighlighters() {
        return this.highlighters.toArray(new Highlighter[this.highlighters.size()]);
    }

    public Component apply(Component stamp, ComponentAdapter adapter) {
        stamp = this.resetDefaultTableCellRenderer(stamp, adapter);
        Iterator iter = this.highlighters.iterator();
        while (iter.hasNext()) {
            stamp = ((Highlighter)iter.next()).highlight(stamp, adapter);
        }
        return stamp;
    }

    private Component resetDefaultTableCellRenderer(Component stamp, ComponentAdapter adapter) {
        if (stamp instanceof DefaultTableCellRenderer) {
            stamp = resetDefaultTableCellRendererHighlighter.highlight(stamp, adapter);
        }
        return stamp;
    }

    @Override
    public void updateUI() {
        int i = 0;
        while (i < this.highlighters.size()) {
            this.updateUI((Highlighter)this.highlighters.get(i));
            ++i;
        }
    }

    private void updateUI(Highlighter hl) {
        if (hl instanceof Highlighter.UIHighlighter) {
            ((Highlighter.UIHighlighter)((Object)hl)).updateUI();
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ChangeListener.class) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
            }
            i -= 2;
        }
    }
}

