/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.border;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.border.Border;

public class IconBorder
implements Border {
    private static final int PAD = 4;
    private Icon icon;
    private int iconPosition;
    private Rectangle iconBounds = new Rectangle();

    public IconBorder() {
        this(null);
    }

    public IconBorder(Icon validIcon) {
        this(validIcon, 11);
    }

    public IconBorder(Icon validIcon, int iconPosition) {
        this.icon = validIcon;
        this.iconPosition = iconPosition;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        int horizontalInset = this.icon.getIconWidth() + 8;
        int iconPosition = this.bidiDecodeLeadingTrailing(c.getComponentOrientation(), this.iconPosition);
        if (iconPosition == 3) {
            return new Insets(0, 0, 0, horizontalInset);
        }
        return new Insets(0, horizontalInset, 0, 0);
    }

    public void setIcon(Icon validIcon) {
        this.icon = validIcon;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int iconPosition = this.bidiDecodeLeadingTrailing(c.getComponentOrientation(), this.iconPosition);
        if (iconPosition == 2) {
            this.iconBounds.y = y + 4;
            this.iconBounds.x = x + width - 4 - this.icon.getIconWidth();
        } else if (iconPosition == 3) {
            this.iconBounds.y = y + (height - this.icon.getIconHeight()) / 2;
            this.iconBounds.x = x + width - 4 - this.icon.getIconWidth();
        } else if (iconPosition == 7) {
            this.iconBounds.y = y + (height - this.icon.getIconHeight()) / 2;
            this.iconBounds.x = x + 4;
        }
        this.iconBounds.width = this.icon.getIconWidth();
        this.iconBounds.height = this.icon.getIconHeight();
        this.icon.paintIcon(c, g, this.iconBounds.x, this.iconBounds.y);
    }

    private int bidiDecodeLeadingTrailing(ComponentOrientation c, int position) {
        if (position == 11) {
            if (!c.isLeftToRight()) {
                return 7;
            }
            return 3;
        }
        if (position == 10) {
            if (!c.isLeftToRight()) {
                return 7;
            }
            return 3;
        }
        return position;
    }
}

