/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.jdesktop.swingx.event.MessageEvent;
import org.jdesktop.swingx.event.MessageListener;
import org.jdesktop.swingx.event.ProgressEvent;
import org.jdesktop.swingx.event.ProgressListener;

public class JXStatusBar
extends JPanel
implements MessageListener,
ProgressListener {
    private JLabel leadingLabel;
    private JLabel trailingLabel;
    private JProgressBar progressBar;
    private Dimension preferredSize;

    public JXStatusBar() {
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.leadingLabel = (JLabel)this.add(new JLabel("", 10));
        this.add(Box.createHorizontalGlue());
        this.progressBar = (JProgressBar)this.add(new JProgressBar());
        this.progressBar.setVisible(false);
        this.trailingLabel = (JLabel)this.add(new JLabel("", 11));
        Font font = this.leadingLabel.getFont().deriveFont(0);
        this.leadingLabel.setFont(font);
        this.trailingLabel.setFont(font);
        this.setFont(font);
        this.preferredSize = new Dimension(this.getWidth("    "), 2 * this.getFontHeight());
    }

    public void setText(String messageText) {
        this.setLeadingMessage(messageText);
    }

    public String getText() {
        return this.getLeadingMessage();
    }

    public void setLeadingMessage(String messageText) {
        this.leadingLabel.setText(messageText);
    }

    public String getLeadingMessage() {
        return this.leadingLabel.getText();
    }

    public void setTrailingMessage(String messageText) {
        this.trailingLabel.setText(messageText);
    }

    public String getTrailingMessage() {
        return this.trailingLabel.getText();
    }

    protected int getWidth(String s) {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        if (fm == null) {
            return 0;
        }
        return fm.stringWidth(s);
    }

    protected int getFontHeight() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        if (fm == null) {
            return 0;
        }
        return fm.getHeight();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    @Override
    public void message(MessageEvent evt) {
        Level level = evt.getLevel();
        if (level == Level.FINE) {
            this.setLeadingMessage(evt.getMessage());
        } else {
            this.setTrailingMessage(evt.getMessage());
        }
    }

    @Override
    public void progressStarted(ProgressEvent evt) {
        boolean indeterminate = evt.isIndeterminate();
        this.progressBar.setIndeterminate(indeterminate);
        if (!indeterminate) {
            this.progressBar.setValue(evt.getMinimum());
            this.progressBar.setMinimum(evt.getMinimum());
            this.progressBar.setMaximum(evt.getMaximum());
        }
        this.progressBar.setVisible(true);
    }

    @Override
    public void progressIncremented(ProgressEvent evt) {
        this.progressBar.setValue(evt.getProgress());
    }

    @Override
    public void progressEnded(ProgressEvent evt) {
        this.progressBar.setVisible(false);
    }
}

