/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.tree;

import java.util.List;
import java.util.ListIterator;
import koala.dynamicjava.tree.BlockStatement;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.TreeUtilities;
import koala.dynamicjava.tree.Type;
import koala.dynamicjava.tree.visitor.Visitor;

public class MethodDeclaration
extends Node {
    public static final String ACCESS_FLAGS = "accessFlags";
    public static final String RETURN_TYPE = "returnType";
    public static final String NAME = "name";
    public static final String PARAMETERS = "parameters";
    public static final String EXCEPTIONS = "exceptions";
    public static final String BODY = "body";
    private int accessFlags;
    private Type returnType;
    private String name;
    private List parameters;
    private List exceptions;
    private BlockStatement body;

    public MethodDeclaration(int flags, Type type, String name, List params, List excepts, BlockStatement body) {
        this(flags, type, name, params, excepts, body, null, 0, 0, 0, 0);
    }

    public MethodDeclaration(int flags, Type type, String name, List params, List excepts, BlockStatement body, String fn, int bl, int bc, int el, int ec) {
        super(fn, bl, bc, el, ec);
        if (type == null) {
            throw new IllegalArgumentException("type == null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name == null");
        }
        if (params == null) {
            throw new IllegalArgumentException("params == null");
        }
        if (excepts == null) {
            throw new IllegalArgumentException("excepts == null");
        }
        this.accessFlags = flags;
        this.returnType = type;
        this.name = name;
        this.parameters = params;
        this.body = body;
        this.exceptions = excepts;
        ListIterator<String> it = excepts.listIterator();
        while (it.hasNext()) {
            it.set(TreeUtilities.listToName((List)it.next()));
        }
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public void setAccessFlags(int f) {
        this.accessFlags = f;
        this.firePropertyChange(ACCESS_FLAGS, this.accessFlags, this.accessFlags);
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public void setReturnType(Type t) {
        if (t == null) {
            throw new IllegalArgumentException("t == null");
        }
        this.returnType = t;
        this.firePropertyChange(RETURN_TYPE, this.returnType, this.returnType);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        if (s == null) {
            throw new IllegalArgumentException("s == null");
        }
        this.name = s;
        this.firePropertyChange(NAME, this.name, this.name);
    }

    public List getParameters() {
        return this.parameters;
    }

    public void setParameters(List l) {
        if (l == null) {
            throw new IllegalArgumentException("l == null");
        }
        this.parameters = l;
        this.firePropertyChange(PARAMETERS, this.parameters, this.parameters);
    }

    public List getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(List l) {
        if (l == null) {
            throw new IllegalArgumentException("l == null");
        }
        this.exceptions = l;
        this.firePropertyChange(EXCEPTIONS, this.exceptions, this.exceptions);
    }

    public BlockStatement getBody() {
        return this.body;
    }

    public void setBody(BlockStatement bs) {
        this.body = bs;
        this.firePropertyChange(BODY, this.body, this.body);
    }

    @Override
    public Object acceptVisitor(Visitor visitor) {
        return visitor.visit(this);
    }
}

