/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import koala.dynamicjava.interpreter.ClassLoaderContainer;
import koala.dynamicjava.interpreter.Interpreter;
import koala.dynamicjava.tree.TypeDeclaration;

public class TreeClassLoader
extends ClassLoader
implements ClassLoaderContainer {
    protected Map classes = new HashMap(11);
    protected Map trees = new HashMap(11);
    protected Interpreter interpreter;
    protected ClassLoader classLoader;

    public TreeClassLoader(Interpreter i) {
        this.interpreter = i;
    }

    public Class defineClass(String name, byte[] code) {
        Class<?> c = this.defineClass(name, code, 0, code.length);
        this.classes.put(name, c);
        this.trees.remove(name);
        return c;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public boolean hasDefined(String name) {
        return this.classes.containsKey(name);
    }

    public Set getClassNames() {
        return this.classes.keySet();
    }

    public void addTree(String name, TypeDeclaration node) {
        this.trees.put(name, node);
    }

    public TypeDeclaration getTree(String name) {
        return (TypeDeclaration)this.trees.get(name);
    }

    public void addURL(URL url) {
        this.classLoader = this.classLoader == null ? new URLClassLoader(new URL[]{url}) : new URLClassLoader(new URL[]{url}, this.classLoader);
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        if (this.classes.containsKey(name)) {
            return (Class)this.classes.get(name);
        }
        try {
            if (this.classLoader != null) {
                return Class.forName(name, true, this.classLoader);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return this.interpreter.loadClass(name);
    }
}

