/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.interpreter;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import koala.dynamicjava.interpreter.Interpreter;
import koala.dynamicjava.interpreter.InterpreterException;
import koala.dynamicjava.interpreter.TreeInterpreter;
import koala.dynamicjava.parser.wrapper.JavaCCParserFactory;

public class Main {
    private static String appname;

    public static void main(String[] args) {
        appname = args[0];
        String fname = "standard input";
        String lpath = "";
        String cpath = "";
        InputStream stream = System.in;
        String init = null;
        String statement = null;
        TreeInterpreter interpreter = new TreeInterpreter(new JavaCCParserFactory());
        interpreter.addLibrarySuffix(".java");
        int arg0 = 1;
        while (args.length > arg0) {
            if (args[arg0].equals("-lp")) {
                if (args.length <= ++arg0) {
                    Main.usage();
                    return;
                }
                lpath = args[arg0++];
                continue;
            }
            if (args[arg0].equals("-cp")) {
                if (args.length <= ++arg0) {
                    Main.usage();
                    return;
                }
                cpath = args[arg0++];
                continue;
            }
            if (args[arg0].equals("-i")) {
                if (args.length <= ++arg0) {
                    Main.usage();
                    return;
                }
                init = args[arg0++];
                continue;
            }
            if (args[arg0].equals("-h")) {
                Main.usage();
                return;
            }
            if (!args[arg0].equals("-c")) break;
            if (args.length <= ++arg0) {
                Main.usage();
                return;
            }
            statement = String.valueOf(args[arg0++]) + ".main(new String[] {";
            if (arg0 < args.length) {
                statement = String.valueOf(statement) + '\"' + args[arg0++] + '\"';
            }
            while (arg0 < args.length) {
                statement = String.valueOf(statement) + ", \"" + args[arg0] + '\"';
                ++arg0;
            }
            statement = String.valueOf(statement) + " });";
            break;
        }
        if (args.length > arg0 + 1) {
            Main.usage();
            return;
        }
        Main.setLibraryPath(interpreter, lpath);
        Main.setClassPath(interpreter, cpath);
        if (init != null) {
            try {
                FileInputStream is = new FileInputStream(init);
                try {
                    interpreter.interpret(is, init);
                }
                catch (InterpreterException e) {
                    System.err.println(e.getMessage());
                }
                catch (Throwable e) {
                    System.err.println(e);
                }
            }
            catch (FileNotFoundException e) {
                System.out.println("File " + init + " not found.");
                return;
            }
        }
        if (args.length > arg0) {
            fname = args[arg0];
            try {
                stream = new FileInputStream(fname);
            }
            catch (FileNotFoundException e) {
                System.out.println("File " + fname + " not found.");
                return;
            }
        }
        try {
            if (statement != null) {
                interpreter.interpret(new StringReader(statement), "main method call");
            } else {
                if (stream == System.in) {
                    System.out.println("Reading from standard input");
                    while (true) {
                        String s = "";
                        InputStreamReader r = new InputStreamReader(stream);
                        int brc1 = 0;
                        int brc2 = 0;
                        while (brc1 < 2 && brc2 < 2) {
                            int ch = ((Reader)r).read();
                            if (ch == 10) {
                                ++brc1;
                            } else if (ch == 13) {
                                ++brc2;
                            } else {
                                brc1 = 0;
                                brc2 = 0;
                            }
                            s = String.valueOf(s) + (char)ch;
                        }
                        Object result = interpreter.interpret(new StringReader(s), fname);
                        System.out.println("=> " + result);
                    }
                }
                interpreter.interpret(stream, fname);
            }
        }
        catch (InterpreterException e) {
            System.err.println(e.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.err.println(e);
        }
        if (stream == System.in) {
            System.out.println("Interactive loop stopped");
        }
    }

    private static void setLibraryPath(Interpreter interp, String lpath) {
        int n;
        while ((n = lpath.indexOf(58)) != -1 || (n = lpath.indexOf(59)) != -1) {
            interp.addLibraryPath(lpath.substring(0, n));
            lpath = lpath.substring(n + 1, lpath.length());
        }
        interp.addLibraryPath(lpath);
    }

    private static void setClassPath(Interpreter interp, String cpath) {
        int n;
        while ((n = cpath.indexOf(58)) != -1 || (n = cpath.indexOf(59)) != -1) {
            interp.addClassPath(cpath.substring(0, n));
            cpath = cpath.substring(n + 1, cpath.length());
        }
        interp.addClassPath(cpath);
    }

    private static void usage() {
        System.out.println("Usage:");
        System.out.println("       " + appname + " [options] [file]");
        System.out.println("     or");
        System.out.println("       " + appname + " [options] -c classname [args ...]");
        System.out.println("Options:");
        System.out.println("       -cp path   the class path ((semi)colon separated paths)");
        System.out.println("       -lp path   the library path ((semi)colon separated paths)");
        System.out.println("       -i file    the initialization file");
    }
}

