/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.gui.resource;

import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import koala.dynamicjava.gui.resource.ActionMap;
import koala.dynamicjava.gui.resource.JComponentModifier;
import koala.dynamicjava.gui.resource.MissingListenerException;
import koala.dynamicjava.gui.resource.ResourceFormatException;
import koala.dynamicjava.gui.resource.ResourceManager;

public class ButtonFactory
extends ResourceManager {
    private static final String ICON_SUFFIX = ".icon";
    private static final String TEXT_SUFFIX = ".text";
    private static final String MNEMONIC_SUFFIX = ".mnemonic";
    private static final String ACTION_SUFFIX = ".action";
    private static final String SELECTED_SUFFIX = ".selected";
    private static final String TOOLTIP_SUFFIX = ".tooltip";
    private final ActionMap actions;

    public ButtonFactory(ResourceBundle rb, ActionMap am) {
        super(rb);
        this.actions = am;
    }

    public JButton createJButton(String name) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JButton result;
        try {
            result = new JButton(this.getString(String.valueOf(name) + TEXT_SUFFIX));
        }
        catch (MissingResourceException e) {
            result = new JButton();
        }
        this.initializeButton(result, name);
        return result;
    }

    public JRadioButton createJRadioButton(String name) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JRadioButton result = new JRadioButton(this.getString(String.valueOf(name) + TEXT_SUFFIX));
        this.initializeButton(result, name);
        try {
            result.setSelected(this.getBoolean(String.valueOf(name) + SELECTED_SUFFIX));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return result;
    }

    public JCheckBox createJCheckBox(String name) throws MissingResourceException, ResourceFormatException, MissingListenerException {
        JCheckBox result = new JCheckBox(this.getString(String.valueOf(name) + TEXT_SUFFIX));
        this.initializeButton(result, name);
        try {
            result.setSelected(this.getBoolean(String.valueOf(name) + SELECTED_SUFFIX));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return result;
    }

    private void initializeButton(AbstractButton b, String name) throws ResourceFormatException, MissingListenerException {
        String s2;
        try {
            s2 = this.getString(String.valueOf(name) + ICON_SUFFIX);
            URL url = this.actions.getClass().getResource(s2);
            if (url != null) {
                b.setIcon(new ImageIcon(url));
            }
        }
        catch (MissingResourceException s2) {
            // empty catch block
        }
        try {
            String str = this.getString(String.valueOf(name) + MNEMONIC_SUFFIX);
            if (str.length() != 1) {
                throw new ResourceFormatException("Malformed mnemonic", this.bundle.getClass().getName(), String.valueOf(name) + MNEMONIC_SUFFIX);
            }
            b.setMnemonic(str.charAt(0));
        }
        catch (MissingResourceException str) {
            // empty catch block
        }
        try {
            Action a = this.actions.getAction(this.getString(String.valueOf(name) + ACTION_SUFFIX));
            if (a == null) {
                throw new MissingListenerException("", "Action", String.valueOf(name) + ACTION_SUFFIX);
            }
            b.addActionListener(a);
            if (a instanceof JComponentModifier) {
                ((JComponentModifier)((Object)a)).addJComponent(b);
            }
        }
        catch (MissingResourceException a) {
            // empty catch block
        }
        try {
            s2 = this.getString(String.valueOf(name) + TOOLTIP_SUFFIX);
            if (s2 != null) {
                b.setToolTipText(s2);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }
}

