/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.gui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import koala.dynamicjava.gui.resource.ActionMap;
import koala.dynamicjava.gui.resource.ButtonFactory;
import koala.dynamicjava.gui.resource.MissingListenerException;
import koala.dynamicjava.gui.resource.ResourceManager;

public class URLChooser
extends JDialog
implements ActionMap {
    protected static final String RESOURCE = "koala.dynamicjava.gui.resources.urlchooser";
    protected static ResourceBundle bundle = ResourceBundle.getBundle("koala.dynamicjava.gui.resources.urlchooser", Locale.getDefault());
    protected static ResourceManager resources = new ResourceManager(bundle);
    protected ButtonFactory buttonFactory;
    protected JTextField textField;
    protected JButton okButton;
    protected JButton clearButton;
    protected Action okAction;
    protected Map listeners = new HashMap();

    public URLChooser(JDialog d, Action okAction) {
        super(d);
        this.initialize(okAction);
    }

    public URLChooser(JFrame f, Action okAction) {
        super(f);
        this.initialize(okAction);
    }

    public String getText() {
        return this.textField.getText();
    }

    protected void initialize(Action okAction) {
        this.okAction = okAction;
        this.setModal(true);
        this.listeners.put("BrowseButtonAction", new BrowseButtonAction());
        this.listeners.put("OKButtonAction", new OKButtonAction());
        this.listeners.put("CancelButtonAction", new CancelButtonAction());
        this.listeners.put("ClearButtonAction", new ClearButtonAction());
        this.setTitle(resources.getString("URLChooser.title"));
        this.buttonFactory = new ButtonFactory(bundle, this);
        this.getContentPane().add("North", this.createURLSelectionPanel());
        this.getContentPane().add("South", this.createButtonsPanel());
    }

    protected JPanel createURLSelectionPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        URLChooser.setConstraintsCoords(constraints, 0, 0, 2, 1);
        p.add((Component)new JLabel(resources.getString("URLChooser.label")), constraints);
        this.textField = new JTextField(30);
        this.textField.getDocument().addDocumentListener(new DocumentAdapter());
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        URLChooser.setConstraintsCoords(constraints, 0, 1, 1, 1);
        p.add((Component)this.textField, constraints);
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        URLChooser.setConstraintsCoords(constraints, 1, 1, 1, 1);
        p.add((Component)this.buttonFactory.createJButton("BrowseButton"), constraints);
        return p;
    }

    protected JPanel createButtonsPanel() {
        JPanel p = new JPanel(new FlowLayout());
        this.okButton = this.buttonFactory.createJButton("OKButton");
        p.add(this.okButton);
        p.add(this.buttonFactory.createJButton("CancelButton"));
        this.clearButton = this.buttonFactory.createJButton("ClearButton");
        p.add(this.clearButton);
        this.okButton.setEnabled(false);
        this.clearButton.setEnabled(false);
        return p;
    }

    protected static void setConstraintsCoords(GridBagConstraints constraints, int x, int y, int width, int height) {
        constraints.gridx = x;
        constraints.gridy = y;
        constraints.gridwidth = width;
        constraints.gridheight = height;
    }

    protected void updateOKButtonAction() {
        this.okButton.setEnabled(!this.textField.getText().equals(""));
    }

    protected void updateClearButtonAction() {
        this.clearButton.setEnabled(!this.textField.getText().equals(""));
    }

    @Override
    public Action getAction(String key) throws MissingListenerException {
        return (Action)this.listeners.get(key);
    }

    protected class BrowseButtonAction
    extends AbstractAction {
        protected BrowseButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileHidingEnabled(false);
            fileChooser.setFileSelectionMode(2);
            int choice = fileChooser.showOpenDialog(URLChooser.this);
            if (choice == 0) {
                File f = fileChooser.getSelectedFile();
                try {
                    URLChooser.this.textField.setText(f.getCanonicalPath());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    protected class CancelButtonAction
    extends AbstractAction {
        protected CancelButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            URLChooser.this.dispose();
            URLChooser.this.textField.setText("");
        }
    }

    protected class ClearButtonAction
    extends AbstractAction {
        protected ClearButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            URLChooser.this.textField.setText("");
        }
    }

    protected class DocumentAdapter
    implements DocumentListener {
        protected DocumentAdapter() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            URLChooser.this.updateOKButtonAction();
            URLChooser.this.updateClearButtonAction();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            URLChooser.this.updateOKButtonAction();
            URLChooser.this.updateClearButtonAction();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            URLChooser.this.updateOKButtonAction();
            URLChooser.this.updateClearButtonAction();
        }
    }

    protected class OKButtonAction
    extends AbstractAction {
        protected OKButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            URLChooser.this.okAction.actionPerformed(e);
            URLChooser.this.dispose();
            URLChooser.this.textField.setText("");
        }
    }
}

