/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import koala.dynamicjava.gui.Main;
import koala.dynamicjava.gui.StringList;
import koala.dynamicjava.gui.URLChooser;
import koala.dynamicjava.gui.resource.ActionMap;
import koala.dynamicjava.gui.resource.ButtonFactory;
import koala.dynamicjava.gui.resource.MissingListenerException;
import koala.dynamicjava.gui.resource.ResourceManager;

public class OptionsDialog
extends JDialog
implements ActionMap {
    protected static final String RESOURCE = "koala.dynamicjava.gui.resources.options";
    protected static ResourceBundle bundle = ResourceBundle.getBundle("koala.dynamicjava.gui.resources.options", Locale.getDefault());
    protected static ResourceManager rManager = new ResourceManager(bundle);
    protected StringList classPathList;
    protected StringList libraryPathList;
    protected URLChooser urlChooser;
    protected String[] classes;
    protected String[] libraries;
    protected Main mainFrame;
    protected InterpreterPanel interpreterPanel;
    protected GUIPanel guiPanel;
    protected Map listeners = new HashMap();

    public OptionsDialog(Main owner) {
        super(owner);
        this.mainFrame = owner;
        this.urlChooser = new URLChooser(this, (Action)new UCOKButtonAction());
        this.listeners.put("OKButtonAction", new OKButtonAction());
        this.listeners.put("CancelButtonAction", new CancelButtonAction());
        this.setTitle(rManager.getString("Dialog.title"));
        this.setSize(rManager.getInteger("Dialog.width"), rManager.getInteger("Dialog.height"));
        this.setModal(true);
        this.getContentPane().add(this.createTabbedPane());
        this.getContentPane().add("South", this.createButtonsPanel());
    }

    @Override
    public Action getAction(String key) throws MissingListenerException {
        return (Action)this.listeners.get(key);
    }

    public String[] getClassPath() {
        return this.classPathList.getStrings();
    }

    public String[] getLibraryPath() {
        return this.libraryPathList.getStrings();
    }

    public String getInterpreterName() {
        return this.interpreterPanel.getName();
    }

    public boolean isInterpreterDefined() {
        return this.interpreterPanel.isExportationSelected();
    }

    public boolean isInitializationSelected() {
        return this.interpreterPanel.isInitializationSelected();
    }

    public String getInitializationFilename() {
        return this.interpreterPanel.getFilename();
    }

    public String getGUIName() {
        return this.guiPanel.getName();
    }

    public boolean isGUIDefined() {
        return this.guiPanel.isSelected();
    }

    public boolean isOutputSelected() {
        return this.guiPanel.isOutputSelected();
    }

    public boolean isErrorSelected() {
        return this.guiPanel.isErrorSelected();
    }

    public boolean isStartupInitializationSelected() {
        return this.guiPanel.isInitializationSelected();
    }

    public String getStartupInitializationFilename() {
        return this.guiPanel.getFilename();
    }

    public OptionSet getOptions() {
        return new OptionSet(this);
    }

    public void setOptions(OptionSet optionSet) {
        this.classPathList.setStrings(optionSet.classPath);
        this.libraryPathList.setStrings(optionSet.libraryPath);
        this.interpreterPanel.setExportationSelected(optionSet.isInterpreterSelected);
        this.interpreterPanel.setName(optionSet.interpreterName);
        this.interpreterPanel.setInitializationSelected(optionSet.interpreterFileSelected);
        this.interpreterPanel.setFilename(optionSet.interpreterFilename);
        this.guiPanel.setSelected(optionSet.isGUISelected);
        this.guiPanel.setName(optionSet.guiName);
        this.guiPanel.setOutputSelected(optionSet.isOutputSelected);
        this.guiPanel.setErrorSelected(optionSet.isErrorSelected);
        this.guiPanel.setInitializationSelected(optionSet.guiFileSelected);
        this.guiPanel.setFilename(optionSet.guiFilename);
    }

    protected JTabbedPane createTabbedPane() {
        JTabbedPane p = new JTabbedPane();
        p.addTab(rManager.getString("General.title"), this.createGeneralPanel());
        p.addTab(rManager.getString("PathPanel.title"), this.createPathPanel());
        return p;
    }

    protected JPanel createGeneralPanel() {
        JPanel p = new JPanel(new BorderLayout());
        JPanel p2 = new JPanel(new GridBagLayout());
        p.add("North", p2);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        OptionsDialog.setConstraintsCoords(constraints, 0, 0, 1, 1);
        this.interpreterPanel = new InterpreterPanel();
        p2.add((Component)this.interpreterPanel, constraints);
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        OptionsDialog.setConstraintsCoords(constraints, 0, 1, 1, 1);
        this.guiPanel = new GUIPanel();
        p2.add((Component)this.guiPanel, constraints);
        return p;
    }

    protected JPanel createPathPanel() {
        JPanel p = new JPanel(new GridLayout(2, 1));
        p.add(this.createClassPathPanel());
        p.add(this.createLibraryPathPanel());
        return p;
    }

    protected JPanel createClassPathPanel() {
        this.classPathList = new StringList(new CPLAddButtonAction());
        this.classPathList.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), rManager.getString("ClassPathPanel.title")));
        return this.classPathList;
    }

    protected JPanel createLibraryPathPanel() {
        this.libraryPathList = new StringList(new LPLAddButtonAction());
        this.libraryPathList.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), rManager.getString("LibraryPathPanel.title")));
        return this.libraryPathList;
    }

    protected JPanel createButtonsPanel() {
        JPanel p = new JPanel(new FlowLayout(2));
        ButtonFactory bf = new ButtonFactory(bundle, this);
        p.add(bf.createJButton("OKButton"));
        p.add(bf.createJButton("CancelButton"));
        return p;
    }

    protected static void setConstraintsCoords(GridBagConstraints constraints, int x, int y, int width, int height) {
        constraints.gridx = x;
        constraints.gridy = y;
        constraints.gridwidth = width;
        constraints.gridheight = height;
    }

    protected class CPLAddButtonAction
    extends AbstractAction {
        protected CPLAddButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OptionsDialog.this.urlChooser.pack();
            Rectangle fr = OptionsDialog.this.getBounds();
            Dimension ud = OptionsDialog.this.urlChooser.getSize();
            OptionsDialog.this.urlChooser.setLocation(fr.x + (fr.width - ud.width) / 2, fr.y + (fr.height - ud.height) / 2);
            OptionsDialog.this.urlChooser.show();
        }
    }

    protected class CancelButtonAction
    extends AbstractAction {
        protected CancelButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OptionsDialog.this.mainFrame.restoreOptions();
            OptionsDialog.this.dispose();
        }
    }

    protected class GUIPanel
    extends JPanel {
        protected JTextField textField;
        protected JCheckBox checkBox;
        protected JLabel label;
        protected JCheckBox outputCheckBox;
        protected JCheckBox errorCheckBox;
        protected JCheckBox fileCheckBox;
        protected JLabel fileLabel;
        protected JTextField fileTextField;
        protected JButton browseButton;

        public GUIPanel() {
            super(new GridBagLayout());
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), rManager.getString("GUIPanel.title")));
            GridBagConstraints constraints = new GridBagConstraints();
            this.checkBox = new JCheckBox(rManager.getString("GUICheckBox.text"));
            this.checkBox.addChangeListener(new CheckBoxChangeListener());
            constraints.insets = new Insets(3, 3, 3, 3);
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            OptionsDialog.setConstraintsCoords(constraints, 0, 0, 3, 1);
            this.add((Component)this.checkBox, constraints);
            this.label = new JLabel(rManager.getString("GUILabel.text"));
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 0;
            OptionsDialog.setConstraintsCoords(constraints, 0, 1, 1, 1);
            this.add((Component)this.label, constraints);
            this.textField = new JTextField();
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            OptionsDialog.setConstraintsCoords(constraints, 1, 1, 2, 1);
            this.add((Component)this.textField, constraints);
            this.label.setEnabled(false);
            this.textField.setEnabled(false);
            this.fileCheckBox = new JCheckBox(rManager.getString("GUIInitFileCheckBox.text"));
            this.fileCheckBox.addChangeListener(new FileCheckBoxChangeListener());
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            OptionsDialog.setConstraintsCoords(constraints, 0, 2, 3, 1);
            this.add((Component)this.fileCheckBox, constraints);
            this.fileLabel = new JLabel(rManager.getString("GUIInitFileLabel.text"));
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            OptionsDialog.setConstraintsCoords(constraints, 0, 3, 3, 1);
            this.add((Component)this.fileLabel, constraints);
            this.fileTextField = new JTextField();
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            OptionsDialog.setConstraintsCoords(constraints, 0, 4, 2, 1);
            this.add((Component)this.fileTextField, constraints);
            ButtonFactory bf = new ButtonFactory(bundle, OptionsDialog.this);
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 0;
            constraints.anchor = 13;
            OptionsDialog.setConstraintsCoords(constraints, 2, 4, 1, 1);
            this.browseButton = bf.createJButton("GUIInitFileBrowseButton");
            this.add((Component)this.browseButton, constraints);
            this.browseButton.addActionListener(new InitFileBrowseButtonAction());
            this.fileLabel.setEnabled(false);
            this.fileTextField.setEnabled(false);
            this.browseButton.setEnabled(false);
            this.outputCheckBox = new JCheckBox(rManager.getString("GUIOutputCheckBox.text"));
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            OptionsDialog.setConstraintsCoords(constraints, 0, 5, 3, 1);
            this.add((Component)this.outputCheckBox, constraints);
            this.errorCheckBox = new JCheckBox(rManager.getString("GUIErrorCheckBox.text"));
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            OptionsDialog.setConstraintsCoords(constraints, 0, 6, 3, 1);
            this.add((Component)this.errorCheckBox, constraints);
        }

        public boolean isSelected() {
            return this.checkBox.isSelected();
        }

        public void setSelected(boolean b) {
            this.checkBox.setSelected(b);
        }

        @Override
        public String getName() {
            return this.textField.getText();
        }

        @Override
        public void setName(String s) {
            this.textField.setText(s);
        }

        public boolean isOutputSelected() {
            return this.outputCheckBox.isSelected();
        }

        public void setOutputSelected(boolean b) {
            this.outputCheckBox.setSelected(b);
        }

        public boolean isErrorSelected() {
            return this.errorCheckBox.isSelected();
        }

        public void setErrorSelected(boolean b) {
            this.errorCheckBox.setSelected(b);
        }

        public boolean isInitializationSelected() {
            return this.fileCheckBox.isSelected();
        }

        public void setInitializationSelected(boolean b) {
            this.fileCheckBox.setSelected(b);
        }

        public String getFilename() {
            return this.fileTextField.getText();
        }

        public void setFilename(String s) {
            this.fileTextField.setText(s);
        }

        protected class CheckBoxChangeListener
        implements ChangeListener {
            protected CheckBoxChangeListener() {
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean selected = GUIPanel.this.checkBox.isSelected();
                GUIPanel.this.label.setEnabled(selected);
                GUIPanel.this.textField.setEnabled(selected);
            }
        }

        protected class FileCheckBoxChangeListener
        implements ChangeListener {
            protected FileCheckBoxChangeListener() {
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean selected = GUIPanel.this.fileCheckBox.isSelected();
                GUIPanel.this.fileLabel.setEnabled(selected);
                GUIPanel.this.fileTextField.setEnabled(selected);
                GUIPanel.this.browseButton.setEnabled(selected);
            }
        }

        protected class InitFileBrowseButtonAction
        extends AbstractAction {
            protected InitFileBrowseButtonAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setFileHidingEnabled(false);
                int choice = fileChooser.showOpenDialog(OptionsDialog.this);
                if (choice == 0) {
                    File f = fileChooser.getSelectedFile();
                    try {
                        GUIPanel.this.fileTextField.setText(f.getCanonicalPath());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    protected class InterpreterPanel
    extends JPanel {
        protected JTextField textField;
        protected JCheckBox checkBox;
        protected JLabel label;
        protected JCheckBox fileCheckBox;
        protected JLabel fileLabel;
        protected JTextField fileTextField;
        protected JButton browseButton;

        public InterpreterPanel() {
            super(new GridBagLayout());
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), rManager.getString("InterpreterPanel.title")));
            GridBagConstraints constraints = new GridBagConstraints();
            this.checkBox = new JCheckBox(rManager.getString("InterpreterCheckBox.text"));
            this.checkBox.addChangeListener(new CheckBoxChangeListener());
            constraints.insets = new Insets(3, 3, 3, 3);
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            OptionsDialog.setConstraintsCoords(constraints, 0, 0, 3, 1);
            this.add((Component)this.checkBox, constraints);
            this.label = new JLabel(rManager.getString("InterpreterLabel.text"));
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            OptionsDialog.setConstraintsCoords(constraints, 0, 1, 1, 1);
            this.add((Component)this.label, constraints);
            this.textField = new JTextField();
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            OptionsDialog.setConstraintsCoords(constraints, 1, 1, 2, 1);
            this.add((Component)this.textField, constraints);
            this.label.setEnabled(false);
            this.textField.setEnabled(false);
            this.fileCheckBox = new JCheckBox(rManager.getString("InitFileCheckBox.text"));
            this.fileCheckBox.addChangeListener(new FileCheckBoxChangeListener());
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            OptionsDialog.setConstraintsCoords(constraints, 0, 2, 3, 1);
            this.add((Component)this.fileCheckBox, constraints);
            this.fileLabel = new JLabel(rManager.getString("InitFileLabel.text"));
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            OptionsDialog.setConstraintsCoords(constraints, 0, 3, 3, 1);
            this.add((Component)this.fileLabel, constraints);
            this.fileTextField = new JTextField();
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            OptionsDialog.setConstraintsCoords(constraints, 0, 4, 2, 1);
            this.add((Component)this.fileTextField, constraints);
            ButtonFactory bf = new ButtonFactory(bundle, OptionsDialog.this);
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 0;
            constraints.anchor = 13;
            OptionsDialog.setConstraintsCoords(constraints, 2, 4, 1, 1);
            this.browseButton = bf.createJButton("InitFileBrowseButton");
            this.add((Component)this.browseButton, constraints);
            this.browseButton.addActionListener(new InitFileBrowseButtonAction());
            this.fileLabel.setEnabled(false);
            this.fileTextField.setEnabled(false);
            this.browseButton.setEnabled(false);
        }

        public boolean isExportationSelected() {
            return this.checkBox.isSelected();
        }

        public void setExportationSelected(boolean b) {
            this.checkBox.setSelected(b);
        }

        @Override
        public String getName() {
            return this.textField.getText();
        }

        @Override
        public void setName(String s) {
            this.textField.setText(s);
        }

        public boolean isInitializationSelected() {
            return this.fileCheckBox.isSelected();
        }

        public void setInitializationSelected(boolean b) {
            this.fileCheckBox.setSelected(b);
        }

        public String getFilename() {
            return this.fileTextField.getText();
        }

        public void setFilename(String s) {
            this.fileTextField.setText(s);
        }

        protected class CheckBoxChangeListener
        implements ChangeListener {
            protected CheckBoxChangeListener() {
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean selected = InterpreterPanel.this.checkBox.isSelected();
                InterpreterPanel.this.label.setEnabled(selected);
                InterpreterPanel.this.textField.setEnabled(selected);
            }
        }

        protected class FileCheckBoxChangeListener
        implements ChangeListener {
            protected FileCheckBoxChangeListener() {
            }

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean selected = InterpreterPanel.this.fileCheckBox.isSelected();
                InterpreterPanel.this.fileLabel.setEnabled(selected);
                InterpreterPanel.this.fileTextField.setEnabled(selected);
                InterpreterPanel.this.browseButton.setEnabled(selected);
            }
        }

        protected class InitFileBrowseButtonAction
        extends AbstractAction {
            protected InitFileBrowseButtonAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setFileHidingEnabled(false);
                int choice = fileChooser.showOpenDialog(OptionsDialog.this);
                if (choice == 0) {
                    File f = fileChooser.getSelectedFile();
                    try {
                        InterpreterPanel.this.fileTextField.setText(f.getCanonicalPath());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    protected class LPLAddButtonAction
    extends AbstractAction {
        protected LPLAddButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileHidingEnabled(false);
            fileChooser.setFileSelectionMode(1);
            int choice = fileChooser.showOpenDialog(OptionsDialog.this);
            if (choice == 0) {
                File f = fileChooser.getSelectedFile();
                try {
                    OptionsDialog.this.libraryPathList.add(f.getCanonicalPath());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    protected class OKButtonAction
    extends AbstractAction {
        protected OKButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (OptionsDialog.this.isInterpreterDefined() && OptionsDialog.this.getInterpreterName().equals("")) {
                JOptionPane.showMessageDialog(OptionsDialog.this, rManager.getString("InterpreterError.text"), rManager.getString("InterpreterError.title"), 0);
                return;
            }
            if (OptionsDialog.this.isInitializationSelected() && OptionsDialog.this.getInitializationFilename().equals("")) {
                JOptionPane.showMessageDialog(OptionsDialog.this, rManager.getString("InterpreterFilenameError.text"), rManager.getString("InterpreterFilenameError.title"), 0);
                return;
            }
            if (OptionsDialog.this.isGUIDefined() && OptionsDialog.this.getGUIName().equals("")) {
                JOptionPane.showMessageDialog(OptionsDialog.this, rManager.getString("GUIError.text"), rManager.getString("GUIError.title"), 0);
                return;
            }
            OptionsDialog.this.dispose();
            int i = JOptionPane.showConfirmDialog(OptionsDialog.this.mainFrame, rManager.getString("ConfirmDialog.text"), rManager.getString("ConfirmDialog.title"), 0, 1);
            if (i == 0) {
                OptionsDialog.this.mainFrame.reinitializeInterpreter();
                OptionsDialog.this.mainFrame.applyOptions();
            }
            try {
                OptionsDialog.this.mainFrame.saveOptions();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(OptionsDialog.this.mainFrame, String.valueOf(rManager.getString("SaveOptionsError.text")) + ex.getMessage(), rManager.getString("SaveOptionsError.title"), 0);
            }
        }
    }

    public static class OptionSet {
        public String[] classPath;
        public String[] libraryPath;
        public boolean isInterpreterSelected;
        public String interpreterName;
        public boolean interpreterFileSelected;
        public String interpreterFilename;
        public boolean isGUISelected;
        public String guiName;
        public boolean isOutputSelected;
        public boolean isErrorSelected;
        public boolean guiFileSelected;
        public String guiFilename;

        public OptionSet() {
            this.classPath = new String[0];
            this.libraryPath = new String[0];
            this.isInterpreterSelected = false;
            this.interpreterName = "";
            this.interpreterFileSelected = false;
            this.interpreterFilename = "";
            this.isGUISelected = false;
            this.guiName = "";
            this.isOutputSelected = false;
            this.isErrorSelected = false;
            this.guiFileSelected = false;
            this.guiFilename = "";
        }

        public OptionSet(OptionsDialog d) {
            this.classPath = d.classPathList.getStrings();
            this.libraryPath = d.libraryPathList.getStrings();
            this.isInterpreterSelected = d.interpreterPanel.isExportationSelected();
            this.interpreterName = d.interpreterPanel.getName();
            this.interpreterFileSelected = d.interpreterPanel.isInitializationSelected();
            this.interpreterFilename = d.interpreterPanel.getFilename();
            this.isGUISelected = d.guiPanel.isSelected();
            this.guiName = d.guiPanel.getName();
            this.isOutputSelected = d.guiPanel.isOutputSelected();
            this.isErrorSelected = d.guiPanel.isErrorSelected();
            this.guiFileSelected = d.guiPanel.isInitializationSelected();
            this.guiFilename = d.guiPanel.getFilename();
        }
    }

    protected class UCOKButtonAction
    extends AbstractAction {
        protected UCOKButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OptionsDialog.this.classPathList.add(OptionsDialog.this.urlChooser.getText());
        }
    }
}

