/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.gui;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import koala.dynamicjava.gui.MessageHandler;
import koala.dynamicjava.gui.resource.ActionMap;
import koala.dynamicjava.gui.resource.JComponentModifier;
import koala.dynamicjava.gui.resource.MissingListenerException;

public class Editor
extends JTextArea
implements ActionMap {
    protected File currentFile;
    protected Document document;
    protected static char[] buffer = new char[4096];
    protected UndoableEditListener undoHandler;
    protected UndoManager undo;
    protected UndoAction undoAction;
    protected RedoAction redoAction;
    protected boolean documentModified;
    protected MessageHandler messageHandler;
    protected Map actions = new HashMap();

    public Editor(MessageHandler mh) {
        this.setFont(new Font("monospaced", 0, 12));
        this.undoHandler = new UndoHandler();
        this.undo = new UndoManager();
        this.actions.put("OpenAction", new OpenAction());
        this.actions.put("SaveAction", new SaveAction());
        this.actions.put("SaveAsAction", new SaveAsAction());
        this.undoAction = new UndoAction();
        this.actions.put("UndoAction", this.undoAction);
        this.redoAction = new RedoAction();
        this.actions.put("RedoAction", this.redoAction);
        this.document = this.getDocument();
        this.document.addDocumentListener(new DocumentAdapter());
        this.document.addUndoableEditListener(this.undoHandler);
        this.messageHandler = mh;
        this.messageHandler.setMainMessage("Status.init");
    }

    public void openFile(String name) {
        this.currentFile = new File(name);
        this.document = new PlainDocument();
        if (this.currentFile.exists()) {
            try {
                int nch;
                FileReader in = new FileReader(this.currentFile);
                while ((nch = ((Reader)in).read(buffer, 0, buffer.length)) != -1) {
                    this.document.insertString(this.document.getLength(), new String(buffer, 0, nch), null);
                }
            }
            catch (Exception ex) {
                System.err.println(ex.toString());
            }
        }
        this.document.addDocumentListener(new DocumentAdapter());
        this.document.addUndoableEditListener(this.undoHandler);
        this.undo = new UndoManager();
        this.undoAction.update();
        this.redoAction.update();
        this.setDocument(this.document);
    }

    protected void saveDocument() {
        if (this.currentFile == null) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileHidingEnabled(false);
            int choice = fileChooser.showSaveDialog(this);
            if (choice == 0) {
                this.currentFile = fileChooser.getSelectedFile();
            }
        }
        if (this.currentFile != null) {
            try {
                FileWriter out = new FileWriter(this.currentFile);
                out.write(this.document.getText(0, this.document.getLength()));
                ((Writer)out).flush();
            }
            catch (Exception ex) {
                System.err.println(ex.toString());
            }
        }
    }

    public void closeProcedure() {
        if (this.documentModified && JOptionPane.showConfirmDialog(this, "Save the current buffer?", "Unsaved Buffer", 0) == 0) {
            this.saveDocument();
        }
    }

    @Override
    public Action getAction(String key) throws MissingListenerException {
        Action[] actions = this.getActions();
        int i = 0;
        while (i < actions.length) {
            if (actions[i].getValue("Name").equals(key)) {
                return actions[i];
            }
            ++i;
        }
        return (Action)this.actions.get(key);
    }

    class DocumentAdapter
    implements DocumentListener {
        DocumentAdapter() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            Editor.this.documentModified = true;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            Editor.this.documentModified = true;
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            Editor.this.documentModified = true;
        }
    }

    class OpenAction
    extends AbstractAction {
        OpenAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Editor.this.documentModified) {
                Editor.this.document.removeUndoableEditListener(Editor.this.undoHandler);
                Editor.this.closeProcedure();
                Editor.this.documentModified = false;
            }
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileHidingEnabled(false);
            int choice = fileChooser.showOpenDialog(Editor.this);
            if (choice == 0) {
                Editor.this.currentFile = fileChooser.getSelectedFile();
                Editor.this.document = new PlainDocument();
                if (Editor.this.currentFile.exists()) {
                    try {
                        int nch;
                        FileReader in = new FileReader(Editor.this.currentFile);
                        while ((nch = ((Reader)in).read(buffer, 0, buffer.length)) != -1) {
                            Editor.this.document.insertString(Editor.this.document.getLength(), new String(buffer, 0, nch), null);
                        }
                        Editor.this.messageHandler.setMainMessage("Status.current", Editor.this.currentFile.getCanonicalPath());
                    }
                    catch (Exception ex) {
                        System.err.println(ex.toString());
                    }
                }
                Editor.this.document.addDocumentListener(new DocumentAdapter());
                Editor.this.document.addUndoableEditListener(Editor.this.undoHandler);
                Editor.this.undo = new UndoManager();
                Editor.this.undoAction.update();
                Editor.this.redoAction.update();
                Editor.this.setDocument(Editor.this.document);
            }
        }
    }

    class RedoAction
    extends AbstractAction
    implements JComponentModifier {
        List components = new LinkedList();

        RedoAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Editor.this.undo.redo();
            }
            catch (CannotRedoException ex) {
                System.out.println(ex);
            }
            this.update();
            Editor.this.undoAction.update();
        }

        @Override
        public void addJComponent(JComponent c) {
            this.components.add(c);
            c.setEnabled(false);
        }

        protected void update() {
            Iterator it = this.components.iterator();
            while (it.hasNext()) {
                ((JComponent)it.next()).setEnabled(Editor.this.undo.canRedo());
            }
        }
    }

    class SaveAction
    extends AbstractAction {
        SaveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Editor.this.documentModified) {
                Editor.this.saveDocument();
                Editor.this.documentModified = false;
                try {
                    Editor.this.messageHandler.setMessage("Status.wrote", Editor.this.currentFile.getCanonicalPath());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    class SaveAsAction
    extends AbstractAction {
        SaveAsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileHidingEnabled(false);
            int choice = fileChooser.showSaveDialog(Editor.this);
            if (choice == 0) {
                Editor.this.currentFile = fileChooser.getSelectedFile();
                try {
                    FileWriter out = new FileWriter(Editor.this.currentFile);
                    out.write(Editor.this.document.getText(0, Editor.this.document.getLength()));
                    ((Writer)out).flush();
                    Editor.this.messageHandler.setMainMessage("Status.current", Editor.this.currentFile.getCanonicalPath());
                }
                catch (Exception ex) {
                    System.err.println(ex.toString());
                }
            }
        }
    }

    class UndoAction
    extends AbstractAction
    implements JComponentModifier {
        List components = new LinkedList();

        UndoAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Editor.this.undo.undo();
            }
            catch (CannotUndoException ex) {
                System.out.println(ex);
            }
            this.update();
            Editor.this.redoAction.update();
        }

        @Override
        public void addJComponent(JComponent c) {
            this.components.add(c);
            c.setEnabled(false);
        }

        protected void update() {
            Editor.this.documentModified = Editor.this.undo.canUndo();
            Iterator it = this.components.iterator();
            while (it.hasNext()) {
                ((JComponent)it.next()).setEnabled(Editor.this.documentModified);
            }
        }
    }

    class UndoHandler
    implements UndoableEditListener {
        UndoHandler() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            Editor.this.undo.addEdit(e.getEdit());
            Editor.this.undoAction.update();
            Editor.this.redoAction.update();
        }
    }
}

