/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.classinfo;

import koala.dynamicjava.classinfo.ClassFinder;
import koala.dynamicjava.classinfo.ClassInfo;
import koala.dynamicjava.classinfo.JavaClassInfo;
import koala.dynamicjava.tree.ArrayType;
import koala.dynamicjava.tree.PrimitiveType;
import koala.dynamicjava.tree.ReferenceType;
import koala.dynamicjava.tree.visitor.VisitorObject;

public class TypeVisitor
extends VisitorObject {
    private final ClassFinder classFinder;
    private final ClassInfo context;

    public TypeVisitor(ClassFinder cf, ClassInfo ctx) {
        this.classFinder = cf;
        this.context = ctx;
    }

    @Override
    public Object visit(PrimitiveType node) {
        return new JavaClassInfo(node.getValue());
    }

    @Override
    public Object visit(ReferenceType node) {
        return this.lookupClass(node.getRepresentation(), this.context);
    }

    @Override
    public Object visit(ArrayType node) {
        ClassInfo ci = (ClassInfo)node.getElementType().acceptVisitor(this);
        return ci.getArrayType();
    }

    private ClassInfo lookupClass(String s, ClassInfo c) {
        try {
            if (c != null) {
                return this.classFinder.lookupClass(s, c);
            }
            return this.classFinder.lookupClass(s);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }
}

