/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.classfile;

import java.util.HashMap;
import java.util.Map;

public abstract class JVMUtilities {
    private static final Map types = new HashMap(11, 1.0f);
    private static final Map stypes = new HashMap(11, 1.0f);

    static {
        types.put(Byte.TYPE, "B");
        types.put(Character.TYPE, "C");
        types.put(Double.TYPE, "D");
        types.put(Float.TYPE, "F");
        types.put(Integer.TYPE, "I");
        types.put(Long.TYPE, "J");
        types.put(Short.TYPE, "S");
        types.put(Boolean.TYPE, "Z");
        types.put(Void.TYPE, "V");
        stypes.put("byte", "B");
        stypes.put("char", "C");
        stypes.put("double", "D");
        stypes.put("float", "F");
        stypes.put("int", "I");
        stypes.put("long", "J");
        stypes.put("short", "S");
        stypes.put("boolean", "Z");
        stypes.put("void", "V");
    }

    public static String getName(Class c) {
        String s = (String)types.get(c);
        if (s != null) {
            return s;
        }
        return c.getName().replace('.', '/');
    }

    public static String getName(String c) {
        String s = (String)stypes.get(c);
        if (s != null) {
            return s;
        }
        if (c.endsWith("[]")) {
            if (c.endsWith("[][]")) {
                return "[" + JVMUtilities.getName(c.substring(0, c.length() - 2));
            }
            return "[" + JVMUtilities.getReturnTypeName(c.substring(0, c.length() - 2));
        }
        return c.replace('.', '/');
    }

    public static String getReturnTypeName(Class c) {
        String s = (String)types.get(c);
        if (s != null) {
            return s;
        }
        return (c.isArray() ? c.getName() : "L" + c.getName() + ";").replace('.', '/');
    }

    public static String getReturnTypeName(String c) {
        String s = (String)stypes.get(c);
        if (s != null) {
            return s;
        }
        if (c.endsWith("[]")) {
            return "[" + JVMUtilities.getReturnTypeName(c.substring(0, c.length() - 2));
        }
        return (c.startsWith("[") ? c : "L" + c + ";").replace('.', '/');
    }

    public static String getParameterTypeName(Class c) {
        return JVMUtilities.getReturnTypeName(c);
    }

    public static String getParameterTypeName(String c) {
        return JVMUtilities.getReturnTypeName(c);
    }

    public static String createMethodDescriptor(String rt, String[] pt) {
        if (pt != null) {
            String result = "(";
            int i = 0;
            while (i < pt.length) {
                result = String.valueOf(result) + pt[i];
                ++i;
            }
            return String.valueOf(result) + ")" + rt;
        }
        return rt;
    }

    private JVMUtilities() {
    }
}

