/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.model;

import java.util.Collection;
import java.util.Collections;
import javax.swing.event.ListDataListener;
import org.openconcerto.utils.change.CollectionChangeEventCreator;
import org.openconcerto.utils.change.ConstructorCreator;
import org.openconcerto.utils.change.IListDataEvent;
import org.openconcerto.utils.model.DefaultIListModel;
import org.openconcerto.utils.model.IMutableListModel;

public class DefaultIMutableListModel<T>
extends DefaultIListModel<T>
implements IMutableListModel<T> {
    private T selectedObject;
    private boolean selectOnAdd = true;
    private boolean selectOnRm = false;

    public DefaultIMutableListModel() {
        this(Collections.emptyList());
    }

    public DefaultIMutableListModel(Collection<? extends T> v) {
        super(v);
        if (this.getSize() > 0) {
            this.selectedObject = this.getElementAt(0);
        }
    }

    public void setSelectedItem(T anObject) {
        if (this.selectedObject != null && !this.selectedObject.equals(anObject) || this.selectedObject == null && anObject != null) {
            this.selectedObject = anObject;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    public T getSelectedItem() {
        return this.selectedObject;
    }

    @Override
    public void addElement(T anObject) {
        this.objects.add(anObject);
        this.fireIntervalAdded(this, this.objects.size() - 1, this.objects.size() - 1);
        if (this.selectOnAdd && this.objects.size() == 1 && this.selectedObject == null && anObject != null) {
            this.setSelectedItem(anObject);
        }
    }

    public void addAll(Collection<? extends T> items) {
        this.addAll(null, items);
    }

    public void addAll(int index, Collection<? extends T> items) {
        this.addAll((Integer)index, items);
    }

    private void addAll(Integer index, Collection<? extends T> items) {
        if (items.size() > 0) {
            if (index == null) {
                index = this.objects.size();
                this.objects.addAll(items);
            } else {
                this.objects.addAll(index, items);
            }
            this.fireIntervalAdded(this, index, index + items.size() - 1);
            if (this.selectOnAdd && this.selectedObject == null) {
                this.setSelectedItem(items.iterator().next());
            }
        }
    }

    public void insertElementAt(T anObject, int index) {
        this.objects.add(index, anObject);
        this.fireIntervalAdded(this, index, index);
    }

    public void removeElementAt(int index) {
        this.removeElementsAt(index, index);
    }

    public void removeElementsAt(int from, int to) {
        ConstructorCreator c = this.createCreator();
        int selectedIndex = this.objects.indexOf(this.selectedObject);
        if (selectedIndex >= from && selectedIndex <= to) {
            if (!this.selectOnRm) {
                this.setSelectedItem(null);
            } else if (from == 0) {
                this.setSelectedItem(this.getSize() == to + 1 ? null : (T)this.getElementAt(to + 1));
            } else {
                this.setSelectedItem(this.getElementAt(from - 1));
            }
        }
        this.objects.subList(from, to + 1).clear();
        this.fireIntervalRemoved(from, to, c);
    }

    public void set(int index, T o) {
        ConstructorCreator c = this.createCreator();
        this.objects.set(index, o);
        this.fireContentsChanged(index, index, c);
    }

    public void replace(T old, T o) {
        this.set(this.getList().indexOf(old), o);
    }

    @Override
    public void removeElement(T anObject) {
        int index = this.objects.indexOf(anObject);
        if (index != -1) {
            this.removeElementAt(index);
        }
    }

    public void removeAllElements() {
        if (this.objects.size() > 0) {
            ConstructorCreator c = this.createCreator();
            int firstIndex = 0;
            int lastIndex = this.objects.size() - 1;
            this.objects.clear();
            this.selectedObject = null;
            this.fireIntervalRemoved(firstIndex, lastIndex, c);
        } else {
            this.selectedObject = null;
        }
    }

    private ConstructorCreator createCreator() {
        return new ConstructorCreator(this, "items", this.objects);
    }

    protected void fireIntervalRemoved(int index0, int index1, CollectionChangeEventCreator c) {
        this.fire(2, index0, index1, c);
    }

    protected void fireContentsChanged(int index0, int index1, CollectionChangeEventCreator c) {
        this.fire(0, index0, index1, c);
    }

    protected void fire(int type, int index0, int index1, CollectionChangeEventCreator c) {
        Object[] listeners = this.listenerList.getListenerList();
        IListDataEvent e = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ListDataListener.class) {
                if (e == null) {
                    e = c.create(this.objects, type, index0, index1);
                }
                switch (type) {
                    case 2: {
                        ((ListDataListener)listeners[i + 1]).intervalRemoved(e);
                        break;
                    }
                    case 0: {
                        ((ListDataListener)listeners[i + 1]).contentsChanged(e);
                        break;
                    }
                    case 1: {
                        ((ListDataListener)listeners[i + 1]).intervalAdded(e);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("wrong type: " + type);
                    }
                }
            }
            i -= 2;
        }
    }

    public final void setSelectOnAdd(boolean selectOnAdd) {
        this.selectOnAdd = selectOnAdd;
    }

    public final void setSelectOnRm(boolean selectOnRm) {
        this.selectOnRm = selectOnRm;
    }
}

