/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.openconcerto.utils.cc.IClosure;

public abstract class DropperQueue<T>
extends Thread {
    private final BlockingDeque<T> items = new LinkedBlockingDeque<T>();
    private final Lock addLock = new ReentrantLock();
    private boolean stop = false;
    private boolean sleeping = false;
    private boolean looping = false;
    private boolean executing = false;

    public DropperQueue(String name) {
        super(name);
    }

    public final synchronized boolean setSleeping(boolean b) {
        if (this.sleeping != b) {
            this.sleeping = b;
            this.signalChange();
            return true;
        }
        return false;
    }

    public synchronized boolean isSleeping() {
        return this.sleeping;
    }

    private final synchronized void setLooping(boolean b) {
        if (this.looping == b) {
            throw new IllegalStateException("Reentrant looping");
        }
        this.looping = b;
        this.signalChange();
    }

    private synchronized void signalChange() {
        this.signalChange(false);
    }

    private synchronized void signalChange(boolean signalClosure) {
        if (signalClosure || !this.isExecuting()) {
            this.interrupt();
        }
    }

    private synchronized void setExecuting(boolean b) {
        this.executing = b;
    }

    private synchronized boolean isExecuting() {
        return this.executing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void await() throws InterruptedException {
        DropperQueue dropperQueue = this;
        synchronized (dropperQueue) {
            if (this.sleeping || this.looping) {
                this.wait();
            }
        }
    }

    public final synchronized void die() {
        this.stop = true;
        this.signalChange(true);
    }

    public final synchronized boolean isDead() {
        return this.stop;
    }

    @Override
    public void run() {
        while (!this.isDead()) {
            try {
                this.await();
                T item = this.items.take();
                this.setExecuting(true);
                Thread.interrupted();
                this.process(item);
            }
            catch (InterruptedException item) {
                this.setExecuting(false);
                continue;
            }
            catch (RuntimeException e) {
                try {
                    e.printStackTrace();
                    continue;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.setExecuting(false);
                }
            }
            this.setExecuting(false);
        }
    }

    protected abstract void process(T var1);

    public final void put(T item) {
        this.addLock.lock();
        try {
            this.items.add(item);
        }
        finally {
            this.addLock.unlock();
        }
    }

    public final void itemsDo(IClosure<? super BlockingDeque<T>> c) {
        this.addLock.lock();
        this.setLooping(true);
        try {
            c.executeChecked(this.items);
        }
        finally {
            this.setLooping(false);
            this.addLock.unlock();
        }
    }
}

