/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.valuewrapper;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import org.openconcerto.ui.valuewrapper.BaseValueWrapper;
import org.openconcerto.utils.checks.ValidState;

public class BooleanValueWrapper
extends BaseValueWrapper<Boolean> {
    private final JComponent comp;
    private final JToggleButton b;

    public BooleanValueWrapper(JToggleButton b) {
        this(b, b);
    }

    public BooleanValueWrapper(JComponent comp, JToggleButton b) {
        Container ancestor = b;
        while (ancestor != null && ancestor != comp) {
            ancestor = b.getParent();
        }
        if (ancestor == null) {
            throw new IllegalArgumentException("Comp is not an ancestor of " + b);
        }
        this.comp = comp;
        this.b = b;
        this.b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BooleanValueWrapper.this.firePropertyChange();
            }
        });
    }

    @Override
    public JComponent getComp() {
        return this.comp;
    }

    @Override
    public Boolean getValue() {
        return this.b.isSelected();
    }

    @Override
    public void setValue(Boolean val) {
        this.b.setSelected(val == null ? false : val);
    }

    @Override
    public ValidState getValidState() {
        return ValidState.getTrueInstance();
    }
}

