/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.component;

import java.util.Collection;
import java.util.List;
import javax.swing.SwingWorker;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.openconcerto.ui.component.ITextComboCache;
import org.openconcerto.ui.component.combo.ISearchableCombo;
import org.openconcerto.utils.change.CollectionChangeEvent;
import org.openconcerto.utils.change.IListDataEvent;
import org.openconcerto.utils.model.DefaultIMutableListModel;
import org.openconcerto.utils.model.Reloadable;

public class IComboCacheListModel
extends DefaultIMutableListModel<String>
implements Reloadable {
    private final ITextComboCache cache;
    private final ListDataListener l;

    public IComboCacheListModel(ITextComboCache c) {
        this.cache = c;
        this.l = new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent e) {
                if (e.getIndex0() < 0) {
                    return;
                }
                CollectionChangeEvent evt = ((IListDataEvent)e).getCollectionChangeEvent();
                this.remove(evt);
                this.add(evt.getItemsAdded());
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                this.add(IComboCacheListModel.this.getList().subList(e.getIndex0(), e.getIndex1() + 1));
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                this.remove(((IListDataEvent)e).getCollectionChangeEvent());
            }

            private void add(Collection<String> toAdd) {
                for (String s : toAdd) {
                    IComboCacheListModel.this.cache.addToCache(s);
                }
            }

            private void remove(CollectionChangeEvent evt) {
                for (String s : evt.getItemsRemoved()) {
                    IComboCacheListModel.this.cache.deleteFromCache(s);
                }
            }
        };
    }

    public final void load(final Runnable r, final boolean readCache) {
        if (this.cache.isValid()) {
            new SwingWorker<List<String>, Object>(){

                @Override
                protected List<String> doInBackground() throws Exception {
                    return IComboCacheListModel.this.cache.loadCache(readCache);
                }

                @Override
                protected void done() {
                    IComboCacheListModel.this.removeListDataListener(IComboCacheListModel.this.l);
                    IComboCacheListModel.this.removeAllElements();
                    try {
                        IComboCacheListModel.this.addAll((Collection)this.get());
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    IComboCacheListModel.this.addListDataListener(IComboCacheListModel.this.l);
                    if (r != null) {
                        r.run();
                    }
                }
            }.execute();
        }
    }

    @Override
    public void reload() {
        this.load(null, false);
    }

    public void initCacheLater(final ISearchableCombo<String> combo) {
        this.load(new Runnable(){

            @Override
            public void run() {
                combo.initCache(IComboCacheListModel.this);
            }
        }, true);
    }
}

