/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model.graph;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jgrapht.Graphs;
import org.jgrapht.graph.DirectedMultigraph;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.DBFileCache;
import org.openconcerto.sql.model.DBItemFileCache;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLSchema;
import org.openconcerto.sql.model.SQLServer;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.graph.BaseGraph;
import org.openconcerto.sql.model.graph.DirectedEdge;
import org.openconcerto.sql.model.graph.GraFFF;
import org.openconcerto.sql.model.graph.LabelPredicate;
import org.openconcerto.sql.model.graph.Link;
import org.openconcerto.sql.model.graph.SQLKey;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.ExceptionUtils;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.xml.JDOMUtils;

public class DatabaseGraph
extends BaseGraph {
    private final DBSystemRoot base;
    private DBRoot context;
    private final List<String> mappedFromFile;
    private final Map<SQLTable, Set<Link>> foreignLinks = new HashMap<SQLTable, Set<Link>>();
    private final Map<List<SQLField>, Link> foreignLink = new HashMap<List<SQLField>, Link>();

    public DatabaseGraph(DBSystemRoot root) throws SQLException {
        super(new DirectedMultigraph<SQLTable, Link>(Link.class));
        this.base = root;
        this.context = null;
        this.mappedFromFile = this.mapTables();
    }

    public DatabaseGraph(DatabaseGraph g, DBRoot root) {
        super(g.getGraphP());
        this.base = root.getDBSystemRoot();
        this.context = root;
        this.mappedFromFile = g.mappedFromFile;
    }

    private final SQLServer getServer() {
        return this.base.getAnc(SQLServer.class);
    }

    private List<String> mapTables() throws SQLException {
        long t2;
        long t1;
        List<String> res = Collections.emptyList();
        Set<SQLTable> tables = this.base.getDescs(SQLTable.class);
        Graphs.addAllVertices(this.getGraphP(), tables);
        DBItemFileCache dir = this.getFileCache();
        ArrayList<String> childrenToFetch = new ArrayList<String>(this.base.getChildrenNames());
        try {
            if (dir != null) {
                Log.get().config("for mapping " + this + " trying xmls in " + dir);
                t1 = System.currentTimeMillis();
                res = this.mapFromXML();
                childrenToFetch.removeAll(res);
                t2 = System.currentTimeMillis();
                Log.get().config("XML took " + (t2 - t1) + "ms for mapping the graph of " + this.base.getName() + "." + res);
            }
        }
        catch (Exception e) {
            SQLBase.logCacheError(dir, e);
            this.deleteGraphFiles();
        }
        if (!childrenToFetch.isEmpty()) {
            t1 = System.currentTimeMillis();
            for (String rootName : childrenToFetch) {
                DBRoot r = this.base.getRoot(rootName);
                for (SQLTable table : r.getDescs(SQLTable.class)) {
                    this.map(table);
                }
                this.save(r);
            }
            t2 = System.currentTimeMillis();
            Log.get().config("JDBC took " + (t2 - t1) + "ms for mapping the graph of " + this.base + "." + childrenToFetch);
        }
        return res;
    }

    private final void addLink(List<SQLField> from, List<SQLField> to, String foreignKeyName) {
        this.addLink(new Link(from, to, foreignKeyName));
    }

    private final void addLink(Link l) {
        DirectedEdge.addEdge(this.getGraphP(), l);
    }

    private void map(final SQLTable table) throws SQLException {
        HashSet<String> metadataFKs = new HashSet<String>();
        List importedKeys = this.base.getDataSource().useConnection(new ConnectionHandlerNoSetup<List, SQLException>(){

            @Override
            public List handle(SQLDataSource ds) throws SQLException {
                DatabaseMetaData metaData = ds.getConnection().getMetaData();
                return (List)SQLDataSource.ARRAY_LIST_HANDLER.handle(metaData.getImportedKeys(table.getBase().getMDName(), table.getSchema().getName(), table.getName()));
            }
        });
        ArrayList<SQLField> from = new ArrayList<SQLField>();
        ArrayList<SQLField> to = new ArrayList<SQLField>();
        String name = null;
        for (Object[] m : importedKeys) {
            String keyName = (String)m[7];
            short seq = ((Number)m[8]).shortValue();
            String foreignCat = this.base.getServer().getSQLSystem().isInterBaseSupported() && m[0] != null ? (String)m[0] : table.getBase().getName();
            String foreignSchema = (String)m[1];
            String foreignTableName = (String)m[2];
            String foreignTableColName = (String)m[3];
            String foreignKeyName = (String)m[11];
            SQLField key = table.getField(keyName);
            SQLSchema schema = table.getBase().getServer().getBase(foreignCat).getSchema(foreignSchema);
            if (schema == null) {
                throw new IllegalStateException(key.getSQLName() + " references " + foreignCat + "." + foreignSchema + " which does not exist (probably filtered by DBSystemRoot.getRootsToMap())");
            }
            SQLTable foreignTable = this.base.getServer().getSQLSystem() == SQLSystem.MYSQL ? this.getTableIgnoringCase(schema, foreignTableName) : (SQLTable)schema.getCheckedChild(foreignTableName);
            metadataFKs.add(keyName);
            if (seq == 1) {
                if (from.size() > 0) {
                    this.addLink(from, to, name);
                }
                from.clear();
                to.clear();
            }
            from.add(key);
            to.add(foreignTable.getField(foreignTableColName));
            name = foreignKeyName;
        }
        if (from.size() > 0) {
            this.addLink(from, to, name);
        }
        Set<String> lexicalFKs = SQLKey.foreignKeys(table);
        lexicalFKs.removeAll(metadataFKs);
        for (String keyName : lexicalFKs) {
            SQLField key = table.getField(keyName);
            this.addLink(Collections.singletonList(key), Collections.singletonList(SQLKey.keyToTable(key).getKey()), null);
        }
    }

    private final SQLTable getTableIgnoringCase(SQLSchema s, String tablename) {
        for (String tname : s.getTableNames()) {
            if (!tname.equalsIgnoreCase(tablename)) continue;
            return s.getTable(tname);
        }
        return null;
    }

    private DBItemFileCache getFileCache() {
        boolean useXML = Boolean.getBoolean("org.openconcerto.sql.structure.useXML");
        DBFileCache d = this.getServer().getFileCache();
        if (!useXML || d == null) {
            return null;
        }
        return d.getChild(this.base);
    }

    private final File getRootFile(String root) {
        DBItemFileCache saveDir = this.getFileCache();
        if (saveDir == null) {
            return null;
        }
        return this.getGraphFile(saveDir.getChild(root));
    }

    private final List<DBItemFileCache> getSavedCaches(boolean withFile) {
        DBItemFileCache item = this.getFileCache();
        if (item == null) {
            return Collections.emptyList();
        }
        return item.getSavedDesc(DBRoot.class, withFile ? "graph.xml" : null);
    }

    final void deleteGraphFiles() {
        for (DBItemFileCache i : this.getSavedCaches(true)) {
            this.getGraphFile(i).delete();
        }
    }

    private File getGraphFile(DBItemFileCache i) {
        return i.getFile("graph.xml");
    }

    boolean save(DBRoot r) {
        String rootName = r.getName();
        File rootFile = this.getRootFile(rootName);
        if (rootFile == null) {
            return false;
        }
        try {
            FileUtils.mkdir_p(rootFile.getParentFile());
            DBRoot root = this.base.getRoot(rootName);
            PrintWriter pWriter = new PrintWriter(new FileOutputStream(rootFile));
            pWriter.print("<root codecVersion=\"");
            pWriter.print("20090210-1530");
            pWriter.print("\"");
            SQLSchema.getVersionAttr(r.getSchema(), pWriter);
            pWriter.println(" >\n");
            for (SQLTable t : root.getDescs(SQLTable.class)) {
                Set<Link> flinks = this.getForeignLinks(t);
                if (flinks.isEmpty()) continue;
                pWriter.print("<table name=\"");
                pWriter.print(JDOMUtils.OUTPUTTER.escapeAttributeEntities(t.getName()));
                pWriter.println("\">");
                for (Link l : flinks) {
                    l.toXML(pWriter);
                }
                pWriter.println("</table>");
            }
            pWriter.println("\n</root>");
            pWriter.close();
            return true;
        }
        catch (Exception e) {
            Log.get().warning("unable to save files in " + rootFile + "\n" + ExceptionUtils.getStackTrace(e));
            return false;
        }
    }

    private List<String> mapFromXML() throws JDOMException, IOException {
        ArrayList<String> res = new ArrayList<String>();
        for (DBItemFileCache cache : this.getSavedCaches(true)) {
            String actualVersion;
            Document doc = new SAXBuilder().build(this.getGraphFile(cache));
            String fileVersion = doc.getRootElement().getAttributeValue("codecVersion");
            if (!"20090210-1530".equals(fileVersion)) {
                throw new IOException("wrong version expected 20090210-1530 got: " + fileVersion);
            }
            String rootName = cache.getName();
            if (!this.base.contains(rootName)) continue;
            DBRoot r = (DBRoot)this.base.getCheckedChild(rootName);
            String xmlVersion = SQLSchema.getVersion(doc.getRootElement());
            if (!CompareUtils.equals(xmlVersion, actualVersion = r.getSchema().getVersion())) {
                throw new IOException("wrong version expected " + actualVersion + " got: " + xmlVersion);
            }
            for (Object o : doc.getRootElement().getChildren()) {
                Element tableElem = (Element)o;
                SQLTable t = r.getTable(tableElem.getAttributeValue("name"));
                for (Object lo : tableElem.getChildren()) {
                    Element linkElem = (Element)lo;
                    this.addLink(Link.fromXML(t, linkElem));
                }
            }
            res.add(rootName);
        }
        return res;
    }

    public Set<Link> getForeignLinks(SQLTable table) {
        Set<Link> res = this.foreignLinks.get(table);
        if (res == null) {
            res = Collections.unmodifiableSet(this.getGraphP().outgoingEdgesOf(table));
            this.foreignLinks.put(table, res);
        }
        return res;
    }

    public Set<SQLField> getForeignKeys(SQLTable table) {
        return DatabaseGraph.getLabels(this.getForeignLinks(table));
    }

    public Link getForeignLink(SQLField fk) {
        return this.getForeignLink(Collections.singletonList(fk));
    }

    public Link getForeignLink(List<SQLField> fk) {
        if (fk.size() == 0) {
            throw new IllegalArgumentException("empty list");
        }
        if (!this.foreignLink.containsKey(fk)) {
            this.foreignLink.put(fk, (Link)CollectionUtils.find(this.getForeignLinks(fk.get(0).getTable()), new LabelPredicate(fk)));
        }
        return this.foreignLink.get(fk);
    }

    public SQLTable getForeignTable(SQLField fk) {
        Link l = this.getForeignLink(fk);
        if (l != null) {
            return (SQLTable)l.getTarget();
        }
        return null;
    }

    public Set<Link> getForeignLinks(SQLTable t1, SQLTable t2) {
        if (t1 == null || t2 == null) {
            throw new NullPointerException("t1: " + t1 + ", t2: " + t2);
        }
        return this.getGraphP().getAllEdges(t1, t2);
    }

    public Set<SQLField> getForeignFields(SQLTable t1, SQLTable t2) {
        return DatabaseGraph.getLabels(this.getForeignLinks(t1, t2));
    }

    public Set<Link> getReferentLinks(SQLTable table) {
        return this.getGraphP().incomingEdgesOf(table);
    }

    public Set<SQLField> getReferentKeys(SQLTable table) {
        return DatabaseGraph.getLabels(this.getReferentLinks(table));
    }

    public GraFFF cloneForFilterKeep(Set<SQLField> linksToKeep) {
        return GraFFF.createKeep(this.getGraphP(), linksToKeep);
    }

    protected DirectedMultigraph<SQLTable, Link> getGraphP() {
        return (DirectedMultigraph)this.getGraph();
    }

    public static <C extends Collection<String>> C getNames(Collection<Link> links, C fields) {
        for (Link l : links) {
            fields.add((String)l.getLabel().getName());
        }
        return fields;
    }

    public static Set<String> getNames(Collection<Link> links) {
        return DatabaseGraph.getNames(links, new HashSet());
    }

    public static <C extends Collection<SQLField>> C getLabels(Collection<Link> links, C fields) {
        for (Link l : links) {
            fields.add((SQLField)l.getLabel());
        }
        return fields;
    }

    public static Set<SQLField> getLabels(Collection<Link> links) {
        return DatabaseGraph.getLabels(links, new HashSet());
    }
}

